/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingIdentityCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractValueCodec;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.common.QName;

final class IdentityCodec
extends AbstractValueCodec<QName, BaseIdentity>
implements BindingIdentityCodec {
    private final LoadingCache<@NonNull QName, @NonNull BaseIdentity> values = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QName, BaseIdentity>(){

        public BaseIdentity load(QName key) {
            Object value;
            Field field;
            Class clazz = IdentityCodec.this.context.getIdentityClass(key);
            try {
                field = clazz.getField("VALUE");
            }
            catch (NoSuchFieldException e) {
                throw new LinkageError(clazz + " does not define required field VALUE", e);
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new LinkageError(field + " is not static");
            }
            try {
                value = clazz.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new LinkageError(field + " is not accesssible", e);
            }
            if (value == null) {
                throw new LinkageError(field + " is null");
            }
            try {
                return (BaseIdentity)clazz.cast(value);
            }
            catch (ClassCastException e) {
                throw new LinkageError(field + " value " + value + " has illegal type", e);
            }
        }
    });
    private final BindingRuntimeContext context;

    IdentityCodec(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    protected BaseIdentity deserializeImpl(QName input) {
        return this.toBinding(input);
    }

    @Override
    protected QName serializeImpl(BaseIdentity input) {
        return this.fromBinding(input);
    }

    public <T extends BaseIdentity> T toBinding(QName qname) {
        try {
            return (T)((BaseIdentity)this.values.get((Object)Objects.requireNonNull(qname)));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new IllegalStateException("Unexpected error translating " + qname, e);
        }
    }

    public QName fromBinding(BaseIdentity bindingValue) {
        return BindingReflections.getQName((BaseIdentity)bindingValue);
    }
}

