/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public abstract class AnnotationsAttribute
implements Attribute {
    public final AnnotationInfo[] annotations;

    protected AnnotationsAttribute(AnnotationInfo[] annotations) {
        this.annotations = annotations;
    }

    public String toString() {
        return this.name() + " " + Arrays.toString(this.annotations);
    }

    static <A extends AnnotationsAttribute> A read(DataInput in, ConstantPool constant_pool, Constructor<A> constructor) throws IOException {
        AnnotationInfo[] annotations = AnnotationInfo.readInfos(in, constant_pool);
        return constructor.init(annotations);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        AnnotationInfo.writeInfos(out, constant_pool, this.annotations);
    }

    @Override
    public int attribute_length() {
        int attribute_length = AnnotationInfo.infos_length(this.annotations);
        return attribute_length;
    }

    @FunctionalInterface
    public static interface Constructor<A extends AnnotationsAttribute> {
        public A init(AnnotationInfo[] var1);
    }
}

