/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.web.service.undertow.configuration.model.Interface;
import org.ops4j.pax.web.service.undertow.configuration.model.IoSubsystem;
import org.ops4j.pax.web.service.undertow.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.configuration.model.SocketBinding;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowSubsystem;

public class UndertowConfiguration {
    private IoSubsystem ioSubsystem;
    private UndertowSubsystem subsystem;
    private final List<SecurityRealm> securityRealms = new ArrayList<SecurityRealm>();
    private final List<Interface> interfaces = new ArrayList<Interface>();
    private final List<SocketBinding> socketBindings = new ArrayList<SocketBinding>();
    private final Map<String, SecurityRealm> securityRealmsMap = new HashMap<String, SecurityRealm>();
    private final Map<String, Interface> interfacesMap = new HashMap<String, Interface>();
    private final Map<String, SocketBinding> socketBindingsMap = new HashMap<String, SocketBinding>();
    private final Map<String, UndertowSubsystem.FileHandler> handlersMap = new HashMap<String, UndertowSubsystem.FileHandler>();
    private final Map<String, UndertowSubsystem.AbstractFilter> filtersMap = new HashMap<String, UndertowSubsystem.AbstractFilter>();
    private final Map<String, IoSubsystem.Worker> workers = new HashMap<String, IoSubsystem.Worker>();
    private final Map<String, IoSubsystem.BufferPool> bufferPools = new HashMap<String, IoSubsystem.BufferPool>();

    public synchronized void init() {
        for (SocketBinding socketBinding : this.socketBindings) {
            this.socketBindingsMap.put(socketBinding.getName(), socketBinding);
        }
        for (SecurityRealm securityRealm : this.securityRealms) {
            this.securityRealmsMap.put(securityRealm.getName(), securityRealm);
        }
        for (Interface interface_ : this.interfaces) {
            this.interfacesMap.put(interface_.getName(), interface_);
        }
        if (this.subsystem != null) {
            for (UndertowSubsystem.FileHandler fileHandler : this.subsystem.getFileHandlers()) {
                this.handlersMap.put(fileHandler.getName(), fileHandler);
            }
            if (this.subsystem.getFilters() != null) {
                for (UndertowSubsystem.ResponseHeaderFilter responseHeaderFilter : this.subsystem.getFilters().getResponseHeaders()) {
                    this.filtersMap.put(responseHeaderFilter.getName(), responseHeaderFilter);
                }
                for (UndertowSubsystem.ErrorPageFilter errorPageFilter : this.subsystem.getFilters().getErrorPages()) {
                    this.filtersMap.put(errorPageFilter.getName(), errorPageFilter);
                }
                for (UndertowSubsystem.CustomFilter customFilter : this.subsystem.getFilters().getCustomFilters()) {
                    this.filtersMap.put(customFilter.getName(), customFilter);
                }
                for (UndertowSubsystem.ExpressionFilter expressionFilter : this.subsystem.getFilters().getExpressionFilters()) {
                    this.filtersMap.put(expressionFilter.getName(), expressionFilter);
                }
                for (UndertowSubsystem.GzipFilter gzipFilter : this.subsystem.getFilters().getGzipFilters()) {
                    this.filtersMap.put(gzipFilter.getName(), gzipFilter);
                }
                for (UndertowSubsystem.RequestLimitFilter requestLimitFilter : this.subsystem.getFilters().getRequestLimitFilters()) {
                    this.filtersMap.put(requestLimitFilter.getName(), requestLimitFilter);
                }
                for (UndertowSubsystem.RewriteFilter rewriteFilter : this.subsystem.getFilters().getRewriteFilters()) {
                    this.filtersMap.put(rewriteFilter.getName(), rewriteFilter);
                }
            }
        }
        if (this.ioSubsystem != null) {
            for (IoSubsystem.Worker worker : this.ioSubsystem.getWorkers()) {
                this.workers.put(worker.getName(), worker);
            }
            for (IoSubsystem.BufferPool bufferPool : this.ioSubsystem.getBufferPools()) {
                this.bufferPools.put(bufferPool.getName(), bufferPool);
            }
        }
    }

    public UndertowSubsystem.FileHandler handler(String name) {
        return this.handlersMap.get(name);
    }

    public UndertowSubsystem.AbstractFilter filter(String name) {
        return this.filtersMap.get(name);
    }

    public SocketBinding socketBinding(String name) {
        return this.socketBindingsMap.get(name);
    }

    public Interface interfaceRef(String name) {
        return this.interfacesMap.get(name);
    }

    public SecurityRealm securityRealm(String name) {
        return this.securityRealmsMap.get(name);
    }

    public IoSubsystem.Worker worker(String name) {
        return this.workers.get(name);
    }

    public IoSubsystem.BufferPool bufferPool(String name) {
        return this.bufferPools.get(name);
    }

    public BindingInfo bindingInfo(String socketBindingName) {
        SocketBinding sb = this.socketBinding(socketBindingName);
        if (sb == null) {
            throw new IllegalArgumentException("Can't find socket binding with name \"" + socketBindingName + "\"");
        }
        Interface iface = this.interfaceRef(sb.getInterfaceRef());
        if (iface == null) {
            throw new IllegalArgumentException("Can't find interface with name \"" + sb.getInterfaceRef() + "\"");
        }
        BindingInfo result = new BindingInfo(sb.getPort());
        for (Interface.InetAddress address : iface.getAddresses()) {
            result.getAddresses().add(address.getIp());
        }
        return result;
    }

    public void setSubsystem(UndertowSubsystem subsystem) {
        this.subsystem = subsystem;
    }

    public UndertowSubsystem getSubsystem() {
        return this.subsystem;
    }

    public IoSubsystem getIoSubsystem() {
        return this.ioSubsystem;
    }

    public void setIoSubsystem(IoSubsystem ioSubsystem) {
        this.ioSubsystem = ioSubsystem;
    }

    public List<SecurityRealm> getSecurityRealms() {
        return this.securityRealms;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public List<SocketBinding> getSocketBindings() {
        return this.socketBindings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n\tsubsystem: ").append(this.subsystem).append("\n");
        sb.append("\tsecurity realms: {");
        for (SecurityRealm sr : this.securityRealms) {
            sb.append("\n\t\t").append(sr);
        }
        sb.append("\n\t}\n\tinterfaces: {");
        for (Interface i : this.interfaces) {
            sb.append("\n\t\t").append(i);
        }
        sb.append("\n\t}\n\tsocket bindings: {");
        for (SocketBinding b : this.socketBindings) {
            sb.append("\n\t\t").append(b);
        }
        sb.append("\n\t}\n\tworkers: {");
        for (IoSubsystem.Worker w : this.workers.values()) {
            sb.append("\n\t\t").append(w);
        }
        sb.append("\n\t}\n\tbuffer pools: {");
        for (IoSubsystem.BufferPool bp : this.bufferPools.values()) {
            sb.append("\n\t\t").append(bp);
        }
        sb.append("\n\t}\n}\n");
        return sb.toString();
    }

    public static class BindingInfo {
        private final List<String> addresses = new ArrayList<String>();
        private final int port;

        public BindingInfo(int port) {
            this.port = port;
        }

        public List<String> getAddresses() {
            return this.addresses;
        }

        public int getPort() {
            return this.port;
        }
    }
}

