/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.web;

import io.undertow.server.handlers.resource.PathResource;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import org.ops4j.pax.web.service.undertow.internal.web.FileETagFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiResourceManager
implements ResourceManager {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiResourceManager.class);
    private final ServletContext osgiScopedServletContext;
    private final String chroot;
    private final FileETagFunction fileETagFunction;
    private final PathResourceManager pathResourceManager;

    public OsgiResourceManager(String chroot, ServletContext osgiScopedServletContext) {
        this.chroot = chroot;
        this.osgiScopedServletContext = osgiScopedServletContext;
        this.fileETagFunction = new FileETagFunction();
        File location = (File)osgiScopedServletContext.getAttribute("javax.servlet.context.tempdir");
        if (location == null) {
            location = new File(System.getProperty("java.io.tmpdir"));
        }
        this.pathResourceManager = (PathResourceManager)PathResourceManager.builder().setBase(location.toPath()).build();
    }

    public Resource getResource(String path) throws IOException {
        URLResource res;
        URL resource;
        block37: {
            URLResource potentialDirectory;
            String fullPath = this.chroot + "/" + path;
            if (!fullPath.startsWith("/")) {
                fullPath = "/" + fullPath;
            }
            resource = null;
            try {
                resource = this.osgiScopedServletContext.getResource(fullPath);
            }
            catch (MalformedURLException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            if (resource == null) {
                return null;
            }
            res = null;
            if (resource.getProtocol().equals("file")) {
                try {
                    Path file = Paths.get(resource.toURI());
                    if (file.toFile().isFile()) {
                        res = new PathResource(file, this.pathResourceManager, resource.getPath(), this.fileETagFunction.generate(file));
                    }
                    if (file.toFile().exists()) {
                        res = new PathResource(file, this.pathResourceManager, resource.getPath(), null);
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    return null;
                }
            } else if (resource.getProtocol().equals("bundle") && !resource.getPath().endsWith("/") && ((potentialDirectory = new URLResource(resource, resource.getPath())).getContentLength() == null || potentialDirectory.getContentLength() == 0L)) {
                try (InputStream is = potentialDirectory.getUrl().openStream();){
                    if (is != null && is.available() != 0) break block37;
                    URL fixedURL = new URL(resource.toExternalForm() + "/");
                    try (InputStream is2 = fixedURL.openStream();){
                        if (is2 != null && is2.available() == 0) {
                            res = new URLResource(fixedURL, fixedURL.getPath());
                        }
                    }
                }
            }
        }
        if (res == null) {
            res = new URLResource(resource, resource.getPath());
        }
        return res;
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
    }

    public void close() throws IOException {
    }
}

