/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.AbstractNamespaceCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.data.util.XpathStringParsingPathArgumentBuilder;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;

@Beta
public abstract class AbstractStringInstanceIdentifierCodec
extends AbstractNamespaceCodec<YangInstanceIdentifier>
implements InstanceIdentifierCodec<String> {
    protected final String serializeImpl(YangInstanceIdentifier data) {
        StringBuilder sb = new StringBuilder();
        DataSchemaContextNode<?> current = this.getDataContextTree().getRoot();
        QNameModule lastModule = null;
        for (YangInstanceIdentifier.PathArgument arg : data.getPathArguments()) {
            Preconditions.checkArgument(((current = current.getChild(arg)) != null ? 1 : 0) != 0, (String)"Invalid input %s: schema for argument %s (after %s) not found", (Object)data, (Object)arg, (Object)sb);
            if (current.isMixin()) continue;
            QName qname = arg.getNodeType();
            sb.append('/');
            this.appendQName(sb, qname, lastModule);
            lastModule = qname.getModule();
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
                for (Map.Entry entry : nip.entrySet()) {
                    this.appendQName(sb.append('['), (QName)entry.getKey(), lastModule);
                    sb.append("='").append(String.valueOf(entry.getValue())).append("']");
                }
                continue;
            }
            if (!(arg instanceof YangInstanceIdentifier.NodeWithValue)) continue;
            YangInstanceIdentifier.NodeWithValue val = (YangInstanceIdentifier.NodeWithValue)arg;
            sb.append("[.='").append(val.getValue()).append("']");
        }
        return sb.toString();
    }

    protected abstract @NonNull DataSchemaContextTree getDataContextTree();

    protected Object deserializeKeyValue(DataSchemaNode schemaNode, LeafrefResolver resolver, String value) {
        return value;
    }

    protected final YangInstanceIdentifier deserializeImpl(String data) {
        return YangInstanceIdentifier.create(new XpathStringParsingPathArgumentBuilder(this, Objects.requireNonNull(data)).build());
    }

    protected QName createQName(@Nullable QNameModule lastModule, String localName) {
        return this.createQName("", localName);
    }
}

