/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.util.AbstractAsContainer;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

@Beta
public class OperationAsContainer
extends AbstractAsContainer
implements OperationDefinition {
    private final @NonNull OperationDefinition delegate;

    OperationAsContainer(OperationDefinition parentNode) {
        this.delegate = Objects.requireNonNull(parentNode);
    }

    public static @NonNull OperationAsContainer of(OperationDefinition delegate) {
        return new OperationAsContainer(delegate);
    }

    protected final @NonNull OperationDefinition delegate() {
        return this.delegate;
    }

    public final Collection<? extends @NonNull TypeDefinition<?>> getTypeDefinitions() {
        return this.delegate.getTypeDefinitions();
    }

    public final Collection<? extends @NonNull GroupingDefinition> getGroupings() {
        return this.delegate.getGroupings();
    }

    public final InputSchemaNode getInput() {
        return this.delegate.getInput();
    }

    public final OutputSchemaNode getOutput() {
        return this.delegate.getOutput();
    }

    public final DataSchemaNode dataChildByName(QName name) {
        if (name.getModule().equals((Object)this.getQName().getModule())) {
            return switch (name.getLocalName()) {
                case "input" -> this.delegate.getInput();
                case "output" -> this.delegate.getOutput();
                default -> null;
            };
        }
        return null;
    }

    public final Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
        return ImmutableSet.of();
    }

    public final Collection<? extends DataSchemaNode> getChildNodes() {
        OutputSchemaNode output;
        ArrayList<Object> ret = new ArrayList<Object>();
        InputSchemaNode input = this.getInput();
        if (input != null) {
            ret.add(input);
        }
        if ((output = this.getOutput()) != null) {
            ret.add(output);
        }
        return ret;
    }
}

