/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;

@Beta
@NonNullByDefault
public final class ObjectRegistry<T> {
    private final Set<ObjectRegistration<? extends T>> objects;
    private final Set<ObjectRegistration<? extends T>> unmodifiableView;
    private final String name;

    private ObjectRegistry(String name, Set<ObjectRegistration<? extends T>> objects) {
        this.name = Objects.requireNonNull(name);
        this.objects = Objects.requireNonNull(objects);
        this.unmodifiableView = Collections.unmodifiableSet(objects);
    }

    public static <T> ObjectRegistry<T> createConcurrent(String name) {
        return new ObjectRegistry<T>(name, ConcurrentHashMap.newKeySet());
    }

    public static <T> ObjectRegistry<T> createSimple(String name) {
        return new ObjectRegistry<T>(name, new HashSet<ObjectRegistration<? extends T>>(1));
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public Stream<? extends T> streamObjects() {
        return this.streamRegistrations().map(ObjectRegistration::getInstance);
    }

    public Set<ObjectRegistration<? extends T>> getRegistrations() {
        return this.unmodifiableView;
    }

    public Stream<ObjectRegistration<? extends T>> streamRegistrations() {
        return this.objects.stream();
    }

    public <O extends T> ObjectRegistration<O> register(O object) {
        Reg ret = new Reg(object, this.objects::remove);
        this.objects.add((ObjectRegistration<T>)ret);
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("objects", this.objects.size()).toString();
    }

    private static final class Reg<T>
    extends AbstractObjectRegistration<T> {
        private @Nullable Consumer<ObjectRegistration<? super T>> removeCall;

        Reg(T instance, Consumer<ObjectRegistration<? super T>> removeCall) {
            super(instance);
            this.removeCall = Objects.requireNonNull(removeCall);
        }

        @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
        protected void removeRegistration() {
            this.removeCall.accept((ObjectRegistration<Reg>)this);
            this.removeCall = null;
        }
    }
}

