/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;

class QNamePredicateImpl
implements Immutable,
QNamePredicate {
    private final QName identifier;
    private final LeafRefPath pathKeyExpression;

    QNamePredicateImpl(QName identifier, LeafRefPath pathKeyExpression) {
        this.identifier = Objects.requireNonNull(identifier, "QNamePredicate: identifier should not be null");
        this.pathKeyExpression = Objects.requireNonNull(pathKeyExpression, "QNamePredicate: pathKeyExpression should not be null");
    }

    public QName getIdentifier() {
        return this.identifier;
    }

    @Override
    public LeafRefPath getPathKeyExpression() {
        return this.pathKeyExpression;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.identifier).append("=current()");
        for (QNameWithPredicate qname : this.pathKeyExpression.getPathFromRoot()) {
            sb.append('/').append(qname);
        }
        return sb.append(']').toString();
    }
}

