/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

@Beta
@NonNullByDefault
public abstract class ResourceYangModuleInfo
implements YangModuleInfo {
    @Override
    public final InputStream openYangTextStream() throws IOException {
        Class<?> subclass = this.getClass();
        String name = (String)Verify.verifyNotNull((Object)this.resourceName(), (String)"%s provided a null resource name", (Object[])new Object[]{subclass});
        InputStream ret = subclass.getResourceAsStream(name);
        if (ret == null) {
            String message = "Failed to open resource " + name + " in context of " + subclass;
            ClassLoader loader = subclass.getClassLoader();
            if (!ResourceYangModuleInfo.class.getClassLoader().equals(loader)) {
                message = message + " (loaded in " + loader + ")";
            }
            throw new IOException(message);
        }
        return ret;
    }

    public final String toString() {
        return this.addToStringHelperAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringHelperAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("resource", Verify.verifyNotNull((Object)this.resourceName()));
    }

    protected abstract String resourceName();
}

