/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DOMDataTreePrefixTableEntry<V>
implements Identifiable<YangInstanceIdentifier.PathArgument>,
Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(DOMDataTreePrefixTableEntry.class);
    private final Map<YangInstanceIdentifier.PathArgument, DOMDataTreePrefixTableEntry<V>> children = new HashMap<YangInstanceIdentifier.PathArgument, DOMDataTreePrefixTableEntry<V>>();
    private final YangInstanceIdentifier.PathArgument identifier;
    private V value;

    DOMDataTreePrefixTableEntry() {
        this.identifier = null;
    }

    DOMDataTreePrefixTableEntry(YangInstanceIdentifier.PathArgument identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public V getValue() {
        return this.value;
    }

    DOMDataTreePrefixTableEntry<V> lookup(YangInstanceIdentifier id) {
        DOMDataTreePrefixTableEntry<V> lastPresentEntry;
        Iterator it = id.getPathArguments().iterator();
        DOMDataTreePrefixTableEntry<V> entry = this;
        DOMDataTreePrefixTableEntry<V> dOMDataTreePrefixTableEntry = lastPresentEntry = entry.getValue() != null ? entry : null;
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument a = (YangInstanceIdentifier.PathArgument)it.next();
            DOMDataTreePrefixTableEntry<V> child = entry.children.get(a);
            if (child == null) {
                LOG.debug("Lookup of {} stopped at {}", (Object)id, (Object)a);
                break;
            }
            entry = child;
            if (child.getValue() == null) continue;
            lastPresentEntry = child;
        }
        return lastPresentEntry;
    }

    void store(YangInstanceIdentifier id, V reg) {
        Iterator it = id.getPathArguments().iterator();
        DOMDataTreePrefixTableEntry<V> entry = this;
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument a = (YangInstanceIdentifier.PathArgument)it.next();
            DOMDataTreePrefixTableEntry<V> child = entry.children.get(a);
            if (child == null) {
                child = new DOMDataTreePrefixTableEntry<V>(a);
                entry.children.put(a, child);
            }
            entry = child;
        }
        Preconditions.checkState((entry.value == null ? 1 : 0) != 0);
        entry.value = reg;
    }

    private boolean remove(Iterator<YangInstanceIdentifier.PathArgument> it) {
        if (it.hasNext()) {
            YangInstanceIdentifier.PathArgument arg = it.next();
            DOMDataTreePrefixTableEntry<V> child = this.children.get(arg);
            if (child != null) {
                if (child.remove(it)) {
                    this.children.remove(arg);
                }
            } else {
                LOG.warn("Cannot remove non-existent child {}", (Object)arg);
            }
        } else {
            this.value = null;
        }
        return this.value == null && this.children.isEmpty();
    }

    void remove(YangInstanceIdentifier id) {
        this.remove(id.getPathArguments().iterator());
    }
}

