/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.InstanceNotificationService;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.InstanceNotificationListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.KeyedInstanceNotificationListenerAdapter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMInstanceNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMInstanceNotificationService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListNotification;

final class InstanceNotificationServiceAdapter
implements InstanceNotificationService {
    static final BindingDOMAdapterBuilder.Factory<InstanceNotificationService> BUILDER_FACTORY = Builder::new;
    private final AdapterContext adapterContext;
    private final DOMInstanceNotificationService domNotifService;

    private InstanceNotificationServiceAdapter(AdapterContext adapterContext, DOMInstanceNotificationService domNotifService) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.domNotifService = Objects.requireNonNull(domNotifService);
    }

    public <P extends DataObject, N extends InstanceNotification<N, P>> Registration registerListener(InstanceNotificationSpec<N, P> spec, InstanceIdentifier<P> path, InstanceNotificationService.Listener<P, N> listener, Executor executor) {
        return this.registerListener(spec, path, new InstanceNotificationListenerAdapter<P, N>(this.adapterContext, spec.type(), listener, executor));
    }

    public <P extends DataObject & Identifiable<K>, N extends KeyedListNotification<N, P, K>, K extends Identifier<P>> Registration registerListener(InstanceNotificationSpec<N, P> spec, KeyedInstanceIdentifier<P, K> path, InstanceNotificationService.KeyedListListener<P, N, K> listener, Executor executor) {
        return this.registerListener(spec, (InstanceIdentifier<?>)path, new KeyedInstanceNotificationListenerAdapter<P, K, N>(this.adapterContext, spec.type(), listener, executor));
    }

    private @NonNull Registration registerListener(@NonNull InstanceNotificationSpec<?, ?> spec, @NonNull InstanceIdentifier<?> path, @NonNull DOMInstanceNotificationListener listener) {
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        return this.domNotifService.registerNotificationListener(new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, serializer.toYangInstanceIdentifier(path)), serializer.getNotificationPath(spec).lastNodeIdentifier(), listener);
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<InstanceNotificationService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected InstanceNotificationService createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new InstanceNotificationServiceAdapter(this.adapterContext(), (DOMInstanceNotificationService)delegates.getInstance(DOMInstanceNotificationService.class));
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMInstanceNotificationService.class);
        }
    }
}

