/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionDatastoreMismatchException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;

abstract class AbstractDOMForwardedTransaction<T extends DOMStoreTransaction>
implements DOMDataTreeTransaction {
    private static final VarHandle BACKING_TX;
    private final @NonNull Object identifier;
    private final Function<LogicalDatastoreType, T> backingTxFactory;
    private volatile Map.Entry<LogicalDatastoreType, T> backingTx;

    protected AbstractDOMForwardedTransaction(Object identifier, Function<LogicalDatastoreType, T> backingTxFactory) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier should not be null");
        this.backingTxFactory = Objects.requireNonNull(backingTxFactory, "Backing transaction factory should not be null");
    }

    protected final @NonNull T getSubtransaction(LogicalDatastoreType datastoreType) {
        LogicalDatastoreType encountered;
        LogicalDatastoreType ds = Objects.requireNonNull(datastoreType, "datastoreType must not be null.");
        Map.Entry<LogicalDatastoreType, T> entry = this.backingTx;
        if (entry == null) {
            DOMStoreTransaction tx = (DOMStoreTransaction)this.backingTxFactory.apply(datastoreType);
            Map.Entry<LogicalDatastoreType, DOMStoreTransaction> newEntry = Map.entry(ds, tx);
            Map.Entry<LogicalDatastoreType, T> witness = BACKING_TX.compareAndExchange(this, null, newEntry);
            if (witness != null) {
                tx.close();
                entry = witness;
            } else {
                entry = newEntry;
            }
        }
        if ((encountered = entry.getKey()) != ds) {
            throw new TransactionDatastoreMismatchException(encountered, ds);
        }
        return (T)((DOMStoreTransaction)entry.getValue());
    }

    protected @Nullable T getSubtransaction() {
        Map.Entry<LogicalDatastoreType, T> entry = this.backingTx;
        return (T)(entry == null ? null : (DOMStoreTransaction)entry.getValue());
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    protected void closeSubtransactions() {
        T subtransaction = this.getSubtransaction();
        if (subtransaction != null) {
            try {
                subtransaction.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Uncaught exception occurred during closing transaction", e);
            }
        }
    }

    static {
        try {
            BACKING_TX = MethodHandles.lookup().findVarHandle(AbstractDOMForwardedTransaction.class, "backingTx", Map.Entry.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

