/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTable;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.spi.ContentRoutedRpcContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;

final class DOMRpcRoutingTable
extends AbstractDOMRoutingTable<DOMRpcIdentifier, YangInstanceIdentifier, DOMRpcImplementation, DOMRpcAvailabilityListener, QName, AbstractDOMRpcRoutingTableEntry> {
    static final DOMRpcRoutingTable EMPTY = new DOMRpcRoutingTable((Map<QName, AbstractDOMRpcRoutingTableEntry>)ImmutableMap.of(), null);

    private DOMRpcRoutingTable(Map<QName, AbstractDOMRpcRoutingTableEntry> rpcs, EffectiveModelContext schemaContext) {
        super(rpcs, schemaContext);
    }

    boolean contains(DOMRpcIdentifier input) {
        AbstractDOMRpcRoutingTableEntry contexts = (AbstractDOMRpcRoutingTableEntry)this.getEntry(input.getType());
        return contexts != null && contexts.containsContext(input.getContextReference());
    }

    protected DOMRpcRoutingTable newInstance(Map<QName, AbstractDOMRpcRoutingTableEntry> operations, EffectiveModelContext schemaContext) {
        return new DOMRpcRoutingTable(operations, schemaContext);
    }

    @Override
    protected ListMultimap<QName, YangInstanceIdentifier> decomposeIdentifiers(Set<DOMRpcIdentifier> rpcs) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (DOMRpcIdentifier i : rpcs) {
            ret.put((Object)i.getType(), (Object)i.getContextReference());
        }
        return ret;
    }

    @Override
    AbstractDOMRpcRoutingTableEntry createOperationEntry(EffectiveModelContext context, QName key, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> implementations) {
        RpcEffectiveStatement rpcDef = DOMRpcRoutingTable.findRpcDefinition(context, key);
        if (rpcDef == null) {
            return new UnknownDOMRpcRoutingTableEntry(key, implementations);
        }
        ContentRoutedRpcContext contentContext = ContentRoutedRpcContext.forRpc((RpcEffectiveStatement)rpcDef);
        return contentContext == null ? new GlobalDOMRpcRoutingTableEntry((QName)rpcDef.argument(), implementations) : new RoutedDOMRpcRoutingTableEntry((QName)rpcDef.argument(), YangInstanceIdentifier.of((QName)contentContext.leaf()), implementations);
    }

    private static @Nullable RpcEffectiveStatement findRpcDefinition(EffectiveModelContext context, QName qname) {
        return context == null ? null : (RpcEffectiveStatement)context.findModuleStatement(qname.getModule()).flatMap(module -> module.findSchemaTreeNode(qname)).filter(RpcEffectiveStatement.class::isInstance).map(RpcEffectiveStatement.class::cast).orElse(null);
    }
}

