/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendReadOnlyTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendReadWriteTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;

final class StandaloneFrontendHistory
extends AbstractFrontendHistory {
    private final @NonNull LocalHistoryIdentifier identifier;
    private final @NonNull ShardDataTree tree;

    private StandaloneFrontendHistory(String persistenceId, ClientIdentifier clientId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, MutableUnsignedLongSet purgedTransactions) {
        super(persistenceId, tree, closedTransactions, purgedTransactions);
        this.identifier = new LocalHistoryIdentifier(clientId, 0L);
        this.tree = Objects.requireNonNull(tree);
    }

    static @NonNull StandaloneFrontendHistory create(String persistenceId, ClientIdentifier clientId, ShardDataTree tree) {
        return new StandaloneFrontendHistory(persistenceId, clientId, tree, (Map<UnsignedLong, Boolean>)ImmutableMap.of(), MutableUnsignedLongSet.of());
    }

    static @NonNull StandaloneFrontendHistory recreate(String persistenceId, ClientIdentifier clientId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, MutableUnsignedLongSet purgedTransactions) {
        return new StandaloneFrontendHistory(persistenceId, clientId, tree, new HashMap<UnsignedLong, Boolean>(closedTransactions), purgedTransactions.mutableCopy());
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    FrontendTransaction createOpenSnapshot(TransactionIdentifier id) {
        return FrontendReadOnlyTransaction.create(this, this.tree.newReadOnlyTransaction(id));
    }

    @Override
    FrontendTransaction createOpenTransaction(TransactionIdentifier id) {
        return FrontendReadWriteTransaction.createOpen(this, this.tree.newReadWriteTransaction(id));
    }

    @Override
    FrontendTransaction createReadyTransaction(TransactionIdentifier id, DataTreeModification mod) {
        return FrontendReadWriteTransaction.createReady(this, id, mod);
    }

    @Override
    ShardDataTreeCohort createFailedCohort(TransactionIdentifier id, DataTreeModification mod, Exception failure) {
        return this.tree.createFailedCohort(id, mod, failure);
    }

    @Override
    ShardDataTreeCohort createReadyCohort(TransactionIdentifier id, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        return this.tree.createReadyCohort(id, mod, participatingShardNames);
    }
}

