/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ExtendedActorSystem;
import akka.serialization.JSerializer;
import akka.util.ClassLoaderObjectInputStream;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.utils.AbstractBatchedModificationsCursor;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;

public final class ReadyLocalTransactionSerializer
extends JSerializer {
    private final ExtendedActorSystem system;

    public ReadyLocalTransactionSerializer(ExtendedActorSystem system) {
        this.system = Objects.requireNonNull(system);
    }

    public int identifier() {
        return 97439437;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object obj) {
        Preconditions.checkArgument((boolean)(obj instanceof ReadyLocalTransaction), (String)"Unsupported object type %s", obj.getClass());
        ReadyLocalTransaction readyLocal = (ReadyLocalTransaction)obj;
        BatchedModifications batched = new BatchedModifications(readyLocal.getTransactionId(), readyLocal.getRemoteVersion());
        batched.setDoCommitOnReady(readyLocal.isDoCommitOnReady());
        batched.setTotalMessagesSent(1);
        batched.setReady(readyLocal.getParticipatingShardNames());
        readyLocal.getModification().applyToCursor((DataTreeModificationCursor)new BatchedCursor(batched));
        return SerializationUtils.serialize((Serializable)batched);
    }

    public Object fromBinaryJava(byte[] bytes, Class<?> clazz) {
        Object object;
        ClassLoaderObjectInputStream is = new ClassLoaderObjectInputStream(this.system.dynamicAccess().classLoader(), (InputStream)new ByteArrayInputStream(bytes));
        try {
            object = is.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException("Failed to deserialize object", e);
            }
        }
        is.close();
        return object;
    }

    private static final class BatchedCursor
    extends AbstractBatchedModificationsCursor {
        private final BatchedModifications message;

        BatchedCursor(BatchedModifications message) {
            this.message = Objects.requireNonNull(message);
        }

        @Override
        protected BatchedModifications getModifications() {
            return this.message;
        }
    }
}

