/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.messages.SerializableMessage;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

public abstract class VersionedExternalizableMessage
implements Externalizable,
SerializableMessage {
    private static final long serialVersionUID = 1L;
    private short version = (short)12;

    public VersionedExternalizableMessage() {
    }

    public VersionedExternalizableMessage(short version) {
        this.version = (short)(version <= 12 ? version : 12);
    }

    public final short getVersion() {
        return this.version;
    }

    protected final @NonNull NormalizedNodeStreamVersion getStreamVersion() {
        if (this.version >= 12) {
            return NormalizedNodeStreamVersion.MAGNESIUM;
        }
        if (this.version == 11) {
            return NormalizedNodeStreamVersion.SODIUM_SR1;
        }
        throw new IllegalStateException("Unsupported version " + this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readShort();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.version);
    }

    @Override
    public final Object toSerializable() {
        short ver = this.getVersion();
        if (ver < 11) {
            throw new UnsupportedOperationException("Version " + ver + " is older than the oldest version supported version 11");
        }
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [version=" + this.getVersion() + "]";
    }
}

