/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.ST;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.raft.persisted.LegacySerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SkipTransactionsPayload
extends AbstractIdentifiablePayload<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(SkipTransactionsPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = SkipTransactionsPayload.externalizableProxySize(ST::new);
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled via externalizable proxy")
    private final @NonNull ImmutableUnsignedLongSet transactionIds;

    SkipTransactionsPayload(@NonNull LocalHistoryIdentifier historyId, byte @NonNull [] serialized, ImmutableUnsignedLongSet transactionIds) {
        super(historyId, serialized);
        this.transactionIds = Objects.requireNonNull(transactionIds);
    }

    public static @NonNull SkipTransactionsPayload create(LocalHistoryIdentifier historyId, ImmutableUnsignedLongSet transactionIds, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            historyId.writeTo((DataOutput)out);
            transactionIds.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {} ids {}", new Object[]{historyId, transactionIds, e});
            throw new IllegalStateException("Failed to serialize " + historyId + " ids " + transactionIds, e);
        }
        return new SkipTransactionsPayload(historyId, out.toByteArray(), transactionIds);
    }

    public @NonNull ImmutableUnsignedLongSet getTransactionIds() {
        return this.transactionIds;
    }

    @Override
    protected ST externalizableProxy(byte[] serialized) {
        return new ST(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<LocalHistoryIdentifier> {
        private static final long serialVersionUID = 1L;
        private ImmutableUnsignedLongSet transactionIds;

        @Override
        protected LocalHistoryIdentifier readIdentifier(DataInput in) throws IOException {
            LocalHistoryIdentifier id = LocalHistoryIdentifier.readFrom((DataInput)in);
            this.transactionIds = ImmutableUnsignedLongSet.readFrom(in);
            return id;
        }

        protected SkipTransactionsPayload createObject(LocalHistoryIdentifier identifier, byte[] serialized) {
            return new Magnesium(identifier, serialized, (ImmutableUnsignedLongSet)Verify.verifyNotNull((Object)this.transactionIds));
        }
    }

    private static final class Magnesium
    extends SkipTransactionsPayload
    implements LegacySerializable {
        private static final long serialVersionUID = 1L;

        Magnesium(LocalHistoryIdentifier historyId, byte[] serialized, ImmutableUnsignedLongSet transactionIds) {
            super(historyId, serialized, transactionIds);
        }
    }
}

