/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.GroupingRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

abstract class CompositeRuntimeTypeBuilder<S extends EffectiveStatement<?, ?>, R extends CompositeRuntimeType> {
    private final List<AugmentRuntimeType> augmentTypes = new ArrayList<AugmentRuntimeType>();
    private final List<RuntimeType> childTypes = new ArrayList<RuntimeType>();
    private final @NonNull S statement;

    CompositeRuntimeTypeBuilder(S statement) {
        this.statement = (EffectiveStatement)Objects.requireNonNull(statement);
    }

    final CompositeRuntimeTypeBuilder<S, R> populate(AugmentResolver resolver, AbstractCompositeGenerator<S, R> generator) {
        resolver.enter(generator);
        try {
            this.processGenerator(resolver, generator);
        }
        finally {
            resolver.exit();
        }
        return this;
    }

    final @NonNull R build(@NonNull GeneratedType generatedType) {
        return this.build(generatedType, this.statement, this.childTypes, this.augmentTypes);
    }

    abstract @NonNull R build(GeneratedType var1, S var2, List<RuntimeType> var3, List<AugmentRuntimeType> var4);

    final @NonNull List<CaseRuntimeType> getCaseChilden() {
        return this.childTypes.stream().map(child -> {
            Verify.verify((boolean)(child instanceof CaseRuntimeType), (String)"Unexpected child %s in %s", (Object)child, this.statement);
            return (CaseRuntimeType)child;
        }).collect(Collectors.toUnmodifiableList());
    }

    final @NonNull S statement() {
        return this.statement;
    }

    boolean isAugmentedChild(QName qname) {
        for (AugmentRuntimeType augment : this.augmentTypes) {
            if (augment.schemaTreeChild(qname) == null) continue;
            return true;
        }
        return false;
    }

    void processAugment(AugmentResolver resolver, AbstractAugmentGenerator augment) {
        this.augmentTypes.add(augment.runtimeTypeIn(resolver, (EffectiveStatement<?, ?>)this.statement));
    }

    private void processGenerator(AugmentResolver resolver, AbstractCompositeGenerator<S, R> generator) {
        if (!(this.statement instanceof ModuleEffectiveStatement)) {
            for (EffectiveStatement stmt : this.statement.effectiveSubstatements()) {
                if (!(stmt instanceof AugmentEffectiveStatement)) continue;
                AugmentEffectiveStatement augment = (AugmentEffectiveStatement)stmt;
                this.processAugment(resolver, resolver.getAugment(augment));
            }
        }
        for (EffectiveStatement stmt : this.statement.effectiveSubstatements()) {
            AbstractExplicitGenerator childGen;
            Object childRuntimeType;
            SchemaTreeEffectiveStatement child;
            if (!(stmt instanceof SchemaTreeEffectiveStatement) || this.isAugmentedChild((QName)(child = (SchemaTreeEffectiveStatement)stmt).argument()) || (childRuntimeType = (childGen = (AbstractExplicitGenerator)Verify.verifyNotNull(CompositeRuntimeTypeBuilder.findChildGenerator(generator, ((QName)child.argument()).getLocalName()), (String)"Cannot find child for %s in %s", (Object[])new Object[]{child, generator})).createInternalRuntimeType(resolver, child)) == null) continue;
            this.childTypes.add((RuntimeType)childRuntimeType);
        }
    }

    private static <S extends SchemaTreeEffectiveStatement<?>> AbstractExplicitGenerator<S, ?> findChildGenerator(AbstractCompositeGenerator<?, ?> parent, String localName) {
        for (Generator child : parent) {
            SchemaTreeEffectiveStatement schemaStmt;
            AbstractExplicitGenerator gen;
            Object genStmt;
            if (!(child instanceof AbstractExplicitGenerator) || !((genStmt = (gen = (AbstractExplicitGenerator)child).statement()) instanceof SchemaTreeEffectiveStatement) || !localName.equals(((QName)(schemaStmt = (SchemaTreeEffectiveStatement)genStmt).argument()).getLocalName())) continue;
            return gen;
        }
        for (GroupingGenerator grouping : parent.groupings()) {
            AbstractExplicitGenerator<S, GroupingRuntimeType> found = CompositeRuntimeTypeBuilder.findChildGenerator(grouping, localName);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

