/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.ri.generated.type.builder;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.AbstractGeneratedType;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

abstract class AbstractGeneratedTOBuilder
extends AbstractGeneratedTypeBuilder<GeneratedTOBuilder>
implements GeneratedTOBuilder {
    private List<GeneratedPropertyBuilder> equalsProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> hashProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> toStringProperties = Collections.emptyList();
    private GeneratedTransferObject extendsType;
    private boolean isTypedef = false;
    private boolean isUnionType = false;
    private TypeDefinition<?> baseType = null;

    AbstractGeneratedTOBuilder(JavaTypeName identifier) {
        super(identifier);
        this.setAbstract(false);
    }

    public final GeneratedTOBuilder setExtendsType(GeneratedTransferObject genTransObj) {
        Preconditions.checkArgument((genTransObj != null ? 1 : 0) != 0, (Object)"Generated Transfer Object cannot be null!");
        this.extendsType = genTransObj;
        return this;
    }

    @Override
    public final MethodSignatureBuilder addMethod(String name) {
        MethodSignatureBuilder builder = super.addMethod(name);
        builder.setAbstract(false);
        return builder;
    }

    public final GeneratedTOBuilder addEqualsIdentity(GeneratedPropertyBuilder property) {
        this.equalsProperties = LazyCollections.lazyAdd(this.equalsProperties, (Object)property);
        return this;
    }

    public final GeneratedTOBuilder addHashIdentity(GeneratedPropertyBuilder property) {
        this.hashProperties = LazyCollections.lazyAdd(this.hashProperties, (Object)property);
        return this;
    }

    public final GeneratedTOBuilder addToStringProperty(GeneratedPropertyBuilder property) {
        this.toStringProperties = LazyCollections.lazyAdd(this.toStringProperties, (Object)property);
        return this;
    }

    @Override
    protected final GeneratedTOBuilder thisInstance() {
        return this;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("equalsProperties", this.equalsProperties).add("hashCodeProperties", this.hashProperties).add("stringProperties", this.toStringProperties);
    }

    public final void setTypedef(boolean newIsTypedef) {
        this.isTypedef = newIsTypedef;
    }

    public final void setBaseType(TypeDefinition<?> typeDef) {
        this.baseType = typeDef;
    }

    public final void setIsUnion(boolean newIsUnion) {
        this.isUnionType = newIsUnion;
    }

    public final boolean isUnion() {
        return this.isUnionType;
    }

    static abstract class AbstractGeneratedTransferObject
    extends AbstractGeneratedType
    implements GeneratedTransferObject {
        private final List<GeneratedProperty> equalsProperties;
        private final List<GeneratedProperty> hashCodeProperties;
        private final List<GeneratedProperty> stringProperties;
        private final GeneratedTransferObject extendsType;
        private final boolean isTypedef;
        private final TypeDefinition<?> baseType;
        private final boolean isUnionType;

        AbstractGeneratedTransferObject(AbstractGeneratedTOBuilder builder) {
            super(builder);
            this.extendsType = builder.extendsType;
            this.equalsProperties = this.toUnmodifiableProperties(builder.equalsProperties);
            this.hashCodeProperties = this.toUnmodifiableProperties(builder.hashProperties);
            this.stringProperties = this.toUnmodifiableProperties(builder.toStringProperties);
            this.isTypedef = builder.isTypedef;
            this.baseType = builder.baseType;
            this.isUnionType = builder.isUnionType;
        }

        public final boolean isTypedef() {
            return this.isTypedef;
        }

        public final TypeDefinition<?> getBaseType() {
            return this.baseType;
        }

        public final boolean isUnionType() {
            return this.isUnionType;
        }

        public final GeneratedTransferObject getSuperType() {
            return this.extendsType;
        }

        public final List<GeneratedProperty> getEqualsIdentifiers() {
            return this.equalsProperties;
        }

        public final List<GeneratedProperty> getHashCodeIdentifiers() {
            return this.hashCodeProperties;
        }

        public final List<GeneratedProperty> getToStringIdentifiers() {
            return this.stringProperties;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).omitNullValues().add("annotations", this.getAnnotations()).add("comment", (Object)this.getComment()).add("extends", (Object)this.getSuperType()).add("implements", this.getImplements()).add("enclosedTypes", this.getEnclosedTypes()).add("constants", this.getConstantDefinitions()).add("enumerations", this.getEnumerations()).add("properties", this.getProperties()).add("equalsProperties", this.equalsProperties).add("hashCodeProperties", this.hashCodeProperties).add("stringProperties", this.stringProperties).add("methods", this.getMethodDefinitions());
        }

        public static final String serializeTypedef(Type type) {
            if (!(type instanceof ParameterizedType)) {
                return type.getFullyQualifiedName();
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            sb.append(parameterizedType.getRawType().getFullyQualifiedName()).append('<');
            boolean first = true;
            for (Type parameter : parameterizedType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(AbstractGeneratedTransferObject.serializeTypedef(parameter));
            }
            return sb.append('>').toString();
        }
    }
}

