/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;

public class ResponsePatternRule
extends PatternRule {
    private String _code;
    private String _reason;

    public ResponsePatternRule() {
        this(null, null, "");
    }

    public ResponsePatternRule(@Name(value="pattern") String pattern, @Name(value="code") String code, @Name(value="reason") String reason) {
        super(pattern);
        this._handling = true;
        this._terminating = true;
        this.setCode(code);
        this.setReason(reason);
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int code = Integer.parseInt(this._code);
        if (code >= 400) {
            if (!StringUtil.isBlank((String)this._reason)) {
                Request.getBaseRequest((ServletRequest)request).getResponse().setStatusWithReason(code, this._reason);
                response.sendError(code, this._reason);
            } else {
                response.sendError(code);
            }
        } else {
            response.setStatus(code, this._reason);
        }
        return target;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._code + "," + this._reason + "]";
    }
}

