/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import javax.servlet.DispatcherType;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;

public class PaxWebFilterMap
extends FilterMap {
    private final FilterModel filterModel;
    private final boolean initialFilter;

    public PaxWebFilterMap(FilterModel filterModel, FilterModel.Mapping mapping) {
        this.filterModel = filterModel;
        this.initialFilter = false;
        this.setFilterName(filterModel.getName());
        this.addMaping(mapping);
    }

    public PaxWebFilterMap(FilterModel filterModel, FilterModel.DynamicMapping mapping) {
        this.filterModel = filterModel;
        this.initialFilter = false;
        this.setFilterName(filterModel.getName());
        this.addDynamicMaping(mapping);
    }

    public PaxWebFilterMap(FilterModel filterModel, boolean initialFilter) {
        this.filterModel = filterModel;
        this.initialFilter = initialFilter;
        this.setFilterName(filterModel.getName());
        if (filterModel.getMappingsPerDispatcherTypes().size() != 1) {
            throw new IllegalArgumentException("Filter Mapping should have one set of mappings specified");
        }
        this.addMaping((FilterModel.Mapping)filterModel.getMappingsPerDispatcherTypes().get(0));
    }

    public void addMaping(FilterModel.Mapping mapping) {
        block5: {
            block6: {
                block4: {
                    if (mapping.getDispatcherTypes() != null) {
                        for (DispatcherType dispatcherType : mapping.getDispatcherTypes()) {
                            this.setDispatcher(dispatcherType.name());
                        }
                    }
                    if (mapping.getRegexPatterns() == null || mapping.getRegexPatterns().length <= 0) break block4;
                    this.addURLPatternDecoded("*");
                    break block5;
                }
                if (mapping.getUrlPatterns() == null || mapping.getUrlPatterns().length <= 0) break block6;
                for (String string : mapping.getUrlPatterns()) {
                    this.addURLPatternDecoded(string);
                }
                break block5;
            }
            if (mapping.getServletNames() == null || mapping.getServletNames().length <= 0) break block5;
            for (String string : mapping.getServletNames()) {
                this.addServletName(string);
            }
        }
    }

    public void addDynamicMaping(FilterModel.DynamicMapping mapping) {
        block5: {
            block4: {
                if (mapping.getDispatcherTypes() != null) {
                    for (DispatcherType dispatcherType : mapping.getDispatcherTypes()) {
                        this.setDispatcher(dispatcherType.name());
                    }
                }
                if (mapping.getUrlPatterns() == null || mapping.getUrlPatterns().length <= 0) break block4;
                for (String string : mapping.getUrlPatterns()) {
                    this.addURLPatternDecoded(string);
                }
                break block5;
            }
            if (mapping.getServletNames() == null || mapping.getServletNames().length <= 0) break block5;
            for (String string : mapping.getServletNames()) {
                this.addServletName(string);
            }
        }
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public boolean isInitial() {
        return this.initialFilter;
    }
}

