/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import com.google.common.io.ByteSource;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.OptionalInt;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.slf4j.Logger;

class SnapshotTracker
implements AutoCloseable {
    private final Logger log;
    private final int totalChunks;
    private final String leaderId;
    private final BufferedOutputStream bufferedStream;
    private final FileBackedOutputStream fileBackedStream;
    private int lastChunkIndex = 0;
    private boolean sealed = false;
    private int lastChunkHashCode = -1;
    private long count;

    SnapshotTracker(Logger log, int totalChunks, String leaderId, RaftActorContext context) {
        this.log = log;
        this.totalChunks = totalChunks;
        this.leaderId = Objects.requireNonNull(leaderId);
        this.fileBackedStream = context.getFileBackedOutputStreamFactory().newInstance();
        this.bufferedStream = new BufferedOutputStream((OutputStream)this.fileBackedStream);
    }

    boolean addChunk(int chunkIndex, byte[] chunk, OptionalInt maybeLastChunkHashCode) throws IOException {
        this.log.debug("addChunk: chunkIndex={}, lastChunkIndex={}, collectedChunks.size={}, lastChunkHashCode={}", new Object[]{chunkIndex, this.lastChunkIndex, this.count, this.lastChunkHashCode});
        if (this.sealed) {
            throw new InvalidChunkException("Invalid chunk received with chunkIndex " + chunkIndex + " all chunks already received");
        }
        if (this.lastChunkIndex + 1 != chunkIndex) {
            throw new InvalidChunkException("Expected chunkIndex " + (this.lastChunkIndex + 1) + " got " + chunkIndex);
        }
        if (maybeLastChunkHashCode.isPresent() && maybeLastChunkHashCode.getAsInt() != this.lastChunkHashCode) {
            throw new InvalidChunkException("The hash code of the recorded last chunk does not match the senders hash code, expected " + this.lastChunkHashCode + " was " + maybeLastChunkHashCode.getAsInt());
        }
        this.bufferedStream.write(chunk);
        this.count += (long)chunk.length;
        this.sealed = chunkIndex == this.totalChunks;
        this.lastChunkIndex = chunkIndex;
        this.lastChunkHashCode = Arrays.hashCode(chunk);
        return this.sealed;
    }

    ByteSource getSnapshotBytes() throws IOException {
        if (!this.sealed) {
            throw new IllegalStateException("lastChunk not received yet");
        }
        this.bufferedStream.close();
        return this.fileBackedStream.asByteSource();
    }

    String getLeaderId() {
        return this.leaderId;
    }

    @Override
    public void close() {
        this.fileBackedStream.cleanup();
    }

    public static class InvalidChunkException
    extends IOException {
        private static final long serialVersionUID = 1L;

        InvalidChunkException(String message) {
            super(message);
        }
    }
}

