/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class AE
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private AppendEntries appendEntries;

    public AE() {
    }

    AE(AppendEntries appendEntries) {
        this.appendEntries = Objects.requireNonNull(appendEntries);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.appendEntries.getLeaderRaftVersion());
        WritableObjects.writeLong((DataOutput)out, (long)this.appendEntries.getTerm());
        out.writeObject(this.appendEntries.getLeaderId());
        WritableObjects.writeLongs((DataOutput)out, (long)this.appendEntries.getPrevLogTerm(), (long)this.appendEntries.getPrevLogIndex());
        WritableObjects.writeLongs((DataOutput)out, (long)this.appendEntries.getLeaderCommit(), (long)this.appendEntries.getReplicatedToAllIndex());
        out.writeShort(this.appendEntries.getPayloadVersion());
        List<ReplicatedLogEntry> entries = this.appendEntries.getEntries();
        out.writeInt(entries.size());
        for (ReplicatedLogEntry e : entries) {
            WritableObjects.writeLongs((DataOutput)out, (long)e.getIndex(), (long)e.getTerm());
            out.writeObject(e.getData());
        }
        out.writeObject(this.appendEntries.getLeaderAddress().orElse(null));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short leaderRaftVersion = in.readShort();
        long term = WritableObjects.readLong((DataInput)in);
        String leaderId = (String)in.readObject();
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        long prevLogTerm = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long prevLogIndex = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        hdr = WritableObjects.readLongHeader((DataInput)in);
        long leaderCommit = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long replicatedToAllIndex = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        short payloadVersion = in.readShort();
        int size = in.readInt();
        ArrayList<ReplicatedLogEntry> entries = new ArrayList<ReplicatedLogEntry>(size);
        for (int i = 0; i < size; ++i) {
            hdr = WritableObjects.readLongHeader((DataInput)in);
            entries.add(new SimpleReplicatedLogEntry(WritableObjects.readFirstLong((DataInput)in, (byte)hdr), WritableObjects.readSecondLong((DataInput)in, (byte)hdr), (Payload)in.readObject()));
        }
        String leaderAddress = (String)in.readObject();
        this.appendEntries = new AppendEntries(term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit, replicatedToAllIndex, payloadVersion, 5, leaderRaftVersion, leaderAddress);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.appendEntries);
    }
}

