/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshot;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class IS
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int LAST_CHUNK_HASHCODE = 16;
    private static final int SERVER_CONFIG = 32;
    private InstallSnapshot installSnapshot;

    public IS() {
    }

    IS(InstallSnapshot installSnapshot) {
        this.installSnapshot = Objects.requireNonNull(installSnapshot);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Optional<ServerConfigurationPayload> serverConfig;
        int flags = 0;
        OptionalInt lastChunkHashCode = this.installSnapshot.getLastChunkHashCode();
        if (lastChunkHashCode.isPresent()) {
            flags |= 0x10;
        }
        if ((serverConfig = this.installSnapshot.getServerConfig()).isPresent()) {
            flags |= 0x20;
        }
        WritableObjects.writeLong((DataOutput)out, (long)this.installSnapshot.getTerm(), (int)flags);
        out.writeObject(this.installSnapshot.getLeaderId());
        WritableObjects.writeLongs((DataOutput)out, (long)this.installSnapshot.getLastIncludedIndex(), (long)this.installSnapshot.getLastIncludedTerm());
        out.writeInt(this.installSnapshot.getChunkIndex());
        out.writeInt(this.installSnapshot.getTotalChunks());
        if (lastChunkHashCode.isPresent()) {
            out.writeInt(lastChunkHashCode.getAsInt());
        }
        if (serverConfig.isPresent()) {
            out.writeObject(serverConfig.get());
        }
        out.writeObject(this.installSnapshot.getData());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        int flags = WritableObjects.longHeaderFlags((byte)hdr);
        long term = WritableObjects.readLongBody((DataInput)in, (byte)hdr);
        String leaderId = (String)in.readObject();
        hdr = WritableObjects.readLongHeader((DataInput)in);
        long lastIncludedIndex = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long lastIncludedTerm = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        int chunkIndex = in.readInt();
        int totalChunks = in.readInt();
        OptionalInt lastChunkHashCode = IS.getFlag(flags, 16) ? OptionalInt.of(in.readInt()) : OptionalInt.empty();
        Optional<ServerConfigurationPayload> serverConfig = IS.getFlag(flags, 32) ? Optional.of((ServerConfigurationPayload)in.readObject()) : Optional.empty();
        byte[] data = (byte[])in.readObject();
        this.installSnapshot = new InstallSnapshot(term, leaderId, lastIncludedIndex, lastIncludedTerm, data, chunkIndex, totalChunks, lastChunkHashCode, serverConfig, 5);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.installSnapshot);
    }

    private static boolean getFlag(int flags, int bit) {
        return (flags & bit) != 0;
    }
}

