/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import akka.dispatch.ControlMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.opendaylight.controller.cluster.raft.persisted.AJE;
import org.opendaylight.controller.cluster.raft.persisted.LegacySerializable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ApplyJournalEntries
implements Serializable,
ControlMessage {
    private static final long serialVersionUID = 1L;
    private final long toIndex;

    public ApplyJournalEntries(long toIndex) {
        this.toIndex = toIndex;
    }

    public final long getToIndex() {
        return this.toIndex;
    }

    public final Object writeReplace() {
        return new AJE(this);
    }

    public final String toString() {
        return "ApplyJournalEntries [toIndex=" + this.toIndex + "]";
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ApplyJournalEntries applyEntries = null;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.applyEntries.toIndex);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.applyEntries = new Legacy(in.readLong());
        }

        private Object readResolve() {
            return this.applyEntries;
        }
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Legacy
    extends ApplyJournalEntries
    implements LegacySerializable {
        private static final long serialVersionUID = 1L;

        Legacy(long toIndex) {
            super(toIndex);
        }
    }
}

