/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.parser.api.YangLibModule;
import org.opendaylight.yangtools.yang.parser.api.YangLibModuleSet;
import org.opendaylight.yangtools.yang.parser.api.YangLibResolver;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.impl.DefaultReactors;
import org.opendaylight.yangtools.yang.parser.impl.DefaultYangParser;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Beta
@Component(immediate=true)
public final class DefaultYangLibResolver
implements YangLibResolver {
    private final CrossSourceStatementReactor reactor;

    public DefaultYangLibResolver() {
        this.reactor = DefaultReactors.defaultReactorBuilder().build();
    }

    @Inject
    @Activate
    public DefaultYangLibResolver(@Reference YangXPathParserFactory xpathFactory) {
        this.reactor = DefaultReactors.defaultReactorBuilder(xpathFactory).build();
    }

    public Collection<Class<? extends SchemaSourceRepresentation>> supportedSourceRepresentations() {
        return DefaultYangParser.REPRESENTATIONS;
    }

    public EffectiveModelContext resolveModuleSet(YangLibModuleSet moduleSet) throws IOException, YangParserException {
        CrossSourceStatementReactor.BuildAction act = this.reactor.newBuild();
        ImmutableSet.Builder features = ImmutableSet.builder();
        for (YangLibModule module : moduleSet.modules().values()) {
            QNameModule namespace = QNameModule.create((XMLNamespace)module.namespace(), (Revision)module.identifier().revision());
            for (UnresolvedQName.Unqualified feat : module.features()) {
                features.add((Object)feat.bindTo(namespace));
            }
            act.addSource(DefaultYangParser.sourceToStatementStream(module.source()));
        }
        for (YangLibModule module : moduleSet.importOnlyModules().values()) {
            act.addLibSource(DefaultYangParser.sourceToStatementStream(module.source()));
        }
        try {
            return act.setSupportedFeatures((Set)features.build()).buildEffective();
        }
        catch (ReactorException e) {
            throw DefaultYangParser.decodeReactorException(e);
        }
    }
}

