/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

final class ParseTreeUtils {
    private ParseTreeUtils() {
    }

    static <T extends ParseTree> T getChild(ParseTree parent, Class<T> type, int offset) {
        return ParseTreeUtils.verifyTree(type, parent.getChild(offset));
    }

    static void verifyChildCount(ParseTree tree, int expected) {
        if (tree.getChildCount() != expected) {
            throw ParseTreeUtils.illegalShape(tree);
        }
    }

    static int verifyAtLeastChildren(ParseTree tree, int expected) {
        int count = tree.getChildCount();
        if (count < expected) {
            throw ParseTreeUtils.illegalShape(tree);
        }
        return count;
    }

    static TerminalNode verifyTerminal(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)tree;
            return terminal;
        }
        throw new VerifyException("'%s' is not a terminal node".formatted(tree.getText()));
    }

    static Token verifyToken(ParseTree parent, int offset, int expected) {
        TerminalNode node = ParseTreeUtils.verifyTerminal(parent.getChild(offset));
        Token token = node.getSymbol();
        int type = token.getType();
        Verify.verify((type == expected ? 1 : 0) != 0, (String)"Item %s has type %s, expected %s", (Object)node, (Object)type, (Object)expected);
        return token;
    }

    static <T extends ParseTree> T verifyTree(Class<T> type, ParseTree tree) {
        if (type.isInstance(tree)) {
            return (T)((ParseTree)type.cast(tree));
        }
        throw new VerifyException("'%s' does not have expected type %s".formatted(tree.getText(), type));
    }

    static VerifyException illegalShape(ParseTree tree) {
        return new VerifyException("Invalid parser shape of '%s'".formatted(tree.getText()));
    }
}

