/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractDataTreeTip;
import org.opendaylight.yangtools.yang.data.tree.impl.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.DataTreeState;
import org.opendaylight.yangtools.yang.data.tree.impl.ExcludedDataSchemaNodeException;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.impl.MapEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.NoopDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryDataTree
extends AbstractDataTreeTip
implements DataTree {
    private static final VarHandle STATE;
    private static final Logger LOG;
    private final DataTreeConfiguration treeConfig;
    private final boolean maskMandatory;
    private volatile DataTreeState state;

    public InMemoryDataTree(TreeNode rootNode, DataTreeConfiguration treeConfig, EffectiveModelContext schemaContext) {
        this.treeConfig = Objects.requireNonNull(treeConfig, "treeConfig");
        this.maskMandatory = true;
        this.state = DataTreeState.createInitial(rootNode);
        if (schemaContext != null) {
            this.setEffectiveModelContext(schemaContext);
        }
    }

    public InMemoryDataTree(TreeNode rootNode, DataTreeConfiguration treeConfig, EffectiveModelContext schemaContext, DataSchemaNode rootSchemaNode, boolean maskMandatory) {
        this.treeConfig = Objects.requireNonNull(treeConfig, "treeConfig");
        this.maskMandatory = maskMandatory;
        this.state = DataTreeState.createInitial(rootNode).withSchemaContext(schemaContext, this.getOperation(rootSchemaNode));
    }

    private ModificationApplyOperation getOperation(DataSchemaNode rootSchemaNode) {
        YangInstanceIdentifier.PathArgument arg;
        if (rootSchemaNode instanceof ContainerLike && this.maskMandatory) {
            return new ContainerModificationStrategy((ContainerLike)rootSchemaNode, this.treeConfig);
        }
        if (rootSchemaNode instanceof ListSchemaNode && (arg = this.treeConfig.getRootPath().getLastPathArgument()) instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return this.maskMandatory ? new MapEntryModificationStrategy((ListSchemaNode)rootSchemaNode, this.treeConfig) : MapEntryModificationStrategy.of((ListSchemaNode)rootSchemaNode, this.treeConfig);
        }
        try {
            return SchemaAwareApplyOperation.from(rootSchemaNode, this.treeConfig);
        }
        catch (ExcludedDataSchemaNodeException e) {
            throw new IllegalArgumentException("Root node does not belong current data tree", e);
        }
    }

    public void setEffectiveModelContext(EffectiveModelContext newModelContext) {
        this.internalSetSchemaContext(newModelContext);
    }

    private synchronized void internalSetSchemaContext(EffectiveModelContext newSchemaContext) {
        DataTreeState newState;
        DataTreeState currentState;
        Objects.requireNonNull(newSchemaContext);
        LOG.debug("Following schema contexts will be attempted {}", (Object)newSchemaContext);
        DataSchemaContextTree contextTree = DataSchemaContextTree.from((EffectiveModelContext)newSchemaContext);
        Optional rootContextNode = contextTree.findChild(this.getRootPath());
        if (!rootContextNode.isPresent()) {
            LOG.warn("Could not find root {} in new schema context, not upgrading", (Object)this.getRootPath());
            return;
        }
        DataSchemaNode rootSchemaNode = ((DataSchemaContextNode)rootContextNode.orElseThrow()).getDataSchemaNode();
        if (!(rootSchemaNode instanceof DataNodeContainer)) {
            LOG.warn("Root {} resolves to non-container type {}, not upgrading", (Object)this.getRootPath(), (Object)rootSchemaNode);
            return;
        }
        ModificationApplyOperation rootNode = this.getOperation(rootSchemaNode);
        while (!STATE.compareAndSet(this, currentState = this.currentState(), newState = currentState.withSchemaContext(newSchemaContext, rootNode))) {
        }
    }

    public InMemoryDataTreeSnapshot takeSnapshot() {
        return this.currentState().newSnapshot();
    }

    public void commit(DataTreeCandidate candidate) {
        DataTreeState newState;
        DataTreeState currentState;
        if (candidate instanceof NoopDataTreeCandidate) {
            return;
        }
        if (!(candidate instanceof InMemoryDataTreeCandidate)) {
            throw new IllegalArgumentException("Invalid candidate class " + candidate.getClass());
        }
        InMemoryDataTreeCandidate c = (InMemoryDataTreeCandidate)candidate;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data Tree is {}", (Object)NormalizedNodes.toStringTree((NormalizedNode)c.getTipRoot().getData()));
        }
        TreeNode newRoot = c.getTipRoot();
        do {
            currentState = this.currentState();
            TreeNode currentRoot = currentState.getRoot();
            LOG.debug("Updating datastore from {} to {}", (Object)currentRoot, (Object)newRoot);
            TreeNode oldRoot = c.getBeforeRoot();
            if (oldRoot != currentRoot) {
                String oldStr = InMemoryDataTree.simpleToString(oldRoot);
                String currentStr = InMemoryDataTree.simpleToString(currentRoot);
                throw new IllegalStateException("Store tree " + currentStr + " and candidate base " + oldStr + " differ.");
            }
            newState = currentState.withRoot(newRoot);
            LOG.trace("Updated state from {} to {}", (Object)currentState, (Object)newState);
        } while (!STATE.compareAndSet(this, currentState, newState));
    }

    private static String simpleToString(Object obj) {
        return obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
    }

    private DataTreeState currentState() {
        return STATE.getAcquire(this);
    }

    @Override
    public YangInstanceIdentifier getRootPath() {
        return this.treeConfig.getRootPath();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("object", (Object)super.toString()).add("config", (Object)this.treeConfig).add("state", (Object)this.currentState()).toString();
    }

    @Override
    protected TreeNode getTipRoot() {
        return this.currentState().getRoot();
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(InMemoryDataTree.class, "state", DataTreeState.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOG = LoggerFactory.getLogger(InMemoryDataTree.class);
    }
}

