/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNodes;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractReadyIterator;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.OperationWithModification;
import org.opendaylight.yangtools.yang.data.tree.impl.RootApplyStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDataTreeModification
extends AbstractCursorAware
implements CursorAwareDataTreeModification,
EffectiveModelContextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTreeModification.class);
    private final RootApplyStrategy strategyTree;
    private final InMemoryDataTreeSnapshot snapshot;
    private final ModifiedNode rootNode;
    private final Version version;
    private static final VarHandle SEALED;
    private volatile int sealed;

    InMemoryDataTreeModification(InMemoryDataTreeSnapshot snapshot, RootApplyStrategy resolver) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.strategyTree = Objects.requireNonNull(resolver).snapshot();
        this.rootNode = ModifiedNode.createUnmodified(snapshot.getRootNode(), this.getStrategy().getChildPolicy());
        this.version = snapshot.getRootNode().getSubtreeVersion().next();
    }

    ModifiedNode getRootModification() {
        return this.rootNode;
    }

    ModificationApplyOperation getStrategy() {
        ModificationApplyOperation ret = this.strategyTree.delegate();
        if (ret == null) {
            throw new IllegalStateException("Schema Context is not available.");
        }
        return ret;
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.snapshot.getEffectiveModelContext();
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkSealed();
        this.checkIdentifierReferencesData(path, data);
        this.resolveModificationFor(path).write(data);
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkSealed();
        this.checkIdentifierReferencesData(path, data);
        this.resolveModificationFor(path).merge(data, this.version);
    }

    public void delete(YangInstanceIdentifier path) {
        this.checkSealed();
        this.resolveModificationFor(path).delete();
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier path) {
        ModifiedNode mod;
        Map.Entry entry = StoreTreeNodes.findClosestsOrFirstMatch((StoreTreeNode)this.rootNode, (YangInstanceIdentifier)path, ModifiedNode.IS_TERMINAL_PREDICATE);
        YangInstanceIdentifier key = (YangInstanceIdentifier)entry.getKey();
        Optional<? extends TreeNode> result = this.resolveSnapshot(key, mod = (ModifiedNode)entry.getValue());
        if (result.isPresent()) {
            NormalizedNode data = result.orElseThrow().getData();
            return NormalizedNodes.findNode((YangInstanceIdentifier)key, (NormalizedNode)data, (YangInstanceIdentifier)path);
        }
        return Optional.empty();
    }

    private Optional<? extends TreeNode> resolveSnapshot(YangInstanceIdentifier path, ModifiedNode modification) {
        Optional<TreeNode> potentialSnapshot = modification.getSnapshot();
        if (potentialSnapshot != null) {
            return potentialSnapshot;
        }
        try {
            return this.resolveModificationStrategy(path).apply(modification, modification.getOriginal(), this.version);
        }
        catch (Exception e) {
            LOG.error("Could not create snapshot for {}:{}", new Object[]{path, modification, e});
            throw e;
        }
    }

    void upgradeIfPossible() {
        if (this.rootNode.getOperation() == LogicalOperation.NONE) {
            this.strategyTree.upgradeIfPossible();
        }
    }

    private ModificationApplyOperation resolveModificationStrategy(YangInstanceIdentifier path) {
        LOG.trace("Resolving modification apply strategy for {}", (Object)path);
        this.upgradeIfPossible();
        return (ModificationApplyOperation)StoreTreeNodes.findNodeChecked((StoreTreeNode)this.getStrategy(), (YangInstanceIdentifier)path);
    }

    private OperationWithModification resolveModificationFor(YangInstanceIdentifier path) {
        this.upgradeIfPossible();
        ModificationApplyOperation operation = this.getStrategy();
        ModifiedNode modification = this.rootNode;
        int depth = 1;
        for (YangInstanceIdentifier.PathArgument pathArg : path.getPathArguments()) {
            if ((operation = operation.childByArg(pathArg)) == null) {
                throw new SchemaValidationFailedException(String.format("Child %s is not present in schema tree.", path.getAncestor(depth)));
            }
            ++depth;
            modification = modification.modifyChild(pathArg, operation, this.version);
        }
        return OperationWithModification.from(operation, modification);
    }

    private void checkSealed() {
        Preconditions.checkState((!this.isSealed() ? 1 : 0) != 0, (Object)"Data Tree is sealed. No further modifications allowed.");
    }

    public String toString() {
        return "MutableDataTree [modification=" + this.rootNode + "]";
    }

    public InMemoryDataTreeModification newModification() {
        Preconditions.checkState((boolean)this.isSealed(), (Object)"Attempted to chain on an unsealed modification");
        if (this.rootNode.getOperation() == LogicalOperation.NONE) {
            return this.snapshot.newModification();
        }
        TreeNode originalSnapshotRoot = this.snapshot.getRootNode();
        Optional<? extends TreeNode> tempRoot = this.getStrategy().apply(this.rootNode, Optional.of(originalSnapshotRoot), this.version);
        Preconditions.checkState((boolean)tempRoot.isPresent(), (Object)"Data tree root is not present, possibly removed by previous modification");
        InMemoryDataTreeSnapshot tempTree = new InMemoryDataTreeSnapshot(this.snapshot.getEffectiveModelContext(), tempRoot.orElseThrow(), this.strategyTree);
        return tempTree.newModification();
    }

    Version getVersion() {
        return this.version;
    }

    boolean isSealed() {
        return SEALED.getAcquire(this) != 0;
    }

    private static void applyChildren(DataTreeModificationCursor cursor, ModifiedNode node) {
        Collection<ModifiedNode> children = node.getChildren();
        if (!children.isEmpty()) {
            cursor.enter(node.getIdentifier());
            for (ModifiedNode child : children) {
                InMemoryDataTreeModification.applyNode(cursor, child);
            }
            cursor.exit();
        }
    }

    private static void applyNode(DataTreeModificationCursor cursor, ModifiedNode node) {
        switch (node.getOperation()) {
            case NONE: {
                break;
            }
            case DELETE: {
                cursor.delete(node.getIdentifier());
                break;
            }
            case MERGE: {
                cursor.merge(node.getIdentifier(), node.getWrittenValue());
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            case TOUCH: {
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            case WRITE: {
                cursor.write(node.getIdentifier(), node.getWrittenValue());
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node operation " + node.getOperation());
            }
        }
    }

    public void applyToCursor(DataTreeModificationCursor cursor) {
        for (ModifiedNode child : this.rootNode.getChildren()) {
            InMemoryDataTreeModification.applyNode(cursor, child);
        }
    }

    static void checkIdentifierReferencesData(YangInstanceIdentifier.PathArgument arg, NormalizedNode data) {
        Preconditions.checkArgument((boolean)arg.equals(data.getIdentifier()), (String)"Instance identifier references %s but data identifier is %s", (Object)arg, (Object)data.getIdentifier());
    }

    private void checkIdentifierReferencesData(YangInstanceIdentifier path, NormalizedNode data) {
        YangInstanceIdentifier.PathArgument arg;
        if (!path.isEmpty()) {
            arg = path.getLastPathArgument();
            Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (String)"Instance identifier %s has invalid null path argument", (Object)path);
        } else {
            arg = this.rootNode.getIdentifier();
        }
        InMemoryDataTreeModification.checkIdentifierReferencesData(arg, data);
    }

    public Optional<DataTreeModificationCursor> openCursor(YangInstanceIdentifier path) {
        OperationWithModification op = this.resolveModificationFor(path);
        return Optional.of((DataTreeModificationCursor)this.openCursor(new InMemoryDataTreeModificationCursor(this, path, op)));
    }

    public void ready() {
        boolean wasRunning = SEALED.compareAndSet(this, 0, 1);
        Preconditions.checkState((boolean)wasRunning, (Object)"Attempted to seal an already-sealed Data Tree.");
        AbstractReadyIterator current = AbstractReadyIterator.create(this.rootNode, this.getStrategy());
        while ((current = current.process(this.version)) != null) {
        }
    }

    static {
        try {
            SEALED = MethodHandles.lookup().findVarHandle(InMemoryDataTreeModification.class, "sealed", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

