/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointNode;
import org.opendaylight.yangtools.rfc8528.data.api.StreamWriterMountPointExtension;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;

@Beta
public abstract class MountPointNormalizedNodeWriter
extends NormalizedNodeWriter {
    MountPointNormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
        super(writer);
    }

    public static @NonNull MountPointNormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        StreamWriterMountPointExtension mountWriter = (StreamWriterMountPointExtension)writer.getExtensions().getInstance(StreamWriterMountPointExtension.class);
        return mountWriter == null ? new Filtering(writer) : new Forwarding(writer, mountWriter);
    }

    public static @NonNull MountPointNormalizedNodeWriter filteringFor(NormalizedNodeStreamWriter writer) {
        return new Filtering(writer);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="SpotBugs does not grok checkArgument()")
    public static @NonNull MountPointNormalizedNodeWriter forwardingFor(NormalizedNodeStreamWriter writer) {
        StreamWriterMountPointExtension mountWriter = (StreamWriterMountPointExtension)writer.getExtensions().getInstance(StreamWriterMountPointExtension.class);
        Preconditions.checkArgument((mountWriter != null ? 1 : 0) != 0, (String)"Writer %s does not support mount points", (Object)writer);
        return new Forwarding(writer, mountWriter);
    }

    protected final boolean wasProcessedAsCompositeNode(NormalizedNode node) throws IOException {
        if (node instanceof MountPointNode) {
            this.writeMountPoint((MountPointNode)node);
            return true;
        }
        return super.wasProcessedAsCompositeNode(node);
    }

    abstract void writeMountPoint(MountPointNode var1) throws IOException;

    private static final class Filtering
    extends MountPointNormalizedNodeWriter {
        Filtering(NormalizedNodeStreamWriter writer) {
            super(writer);
        }

        @Override
        void writeMountPoint(MountPointNode node) {
        }
    }

    private static final class Forwarding
    extends MountPointNormalizedNodeWriter {
        private final StreamWriterMountPointExtension mountWriter;

        Forwarding(NormalizedNodeStreamWriter writer, StreamWriterMountPointExtension mountWriter) {
            super(writer);
            this.mountWriter = Objects.requireNonNull(mountWriter);
        }

        @Override
        void writeMountPoint(MountPointNode node) throws IOException {
            try (MountPointNormalizedNodeWriter writer = Forwarding.forStreamWriter(this.mountWriter.startMountPoint(node.getIdentifier(), node.getMountPointContext()));){
                for (DataContainerChild child : node.body()) {
                    writer.write((NormalizedNode)child);
                }
            }
        }
    }
}

