/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractImplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.NotificationGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;

final class NotificationServiceGenerator
extends AbstractImplicitGenerator {
    private final List<NotificationGenerator> notifs;

    NotificationServiceGenerator(ModuleGenerator parent, List<NotificationGenerator> notifs) {
        super(parent);
        this.notifs = Objects.requireNonNull(notifs);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.NOTIFICATION_LISTENER;
    }

    @Override
    String classSuffix() {
        return "Listener";
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        ((GeneratedTypeBuilder)builder.addImplementsType((Type)BindingTypes.NOTIFICATION_LISTENER)).addAnnotation(DEPRECATED_ANNOTATION);
        for (NotificationGenerator gen : this.notifs) {
            MethodSignatureBuilder notificationMethod = (MethodSignatureBuilder)((MethodSignatureBuilder)builder.addMethod("on" + gen.assignedName()).setAccessModifier(AccessModifier.PUBLIC)).addParameter((Type)gen.getGeneratedType(builderFactory), "notification").setReturnType((Type)Types.primitiveVoidType());
            NotificationEffectiveStatement stmt = (NotificationEffectiveStatement)gen.statement();
            Verify.verify((boolean)(stmt instanceof DocumentedNode.WithStatus), (String)"Unexpected statement %s", (Object)stmt);
            DocumentedNode.WithStatus withStatus = (DocumentedNode.WithStatus)stmt;
            NotificationServiceGenerator.annotateDeprecatedIfNecessary(withStatus, (AnnotableTypeBuilder)notificationMethod);
            if (withStatus.getStatus() != Status.OBSOLETE) continue;
            notificationMethod.setDefault(true);
        }
        return builder.build();
    }
}

