/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractImplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeMemberComment;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;

@Deprecated(since="11.0.0", forRemoval=true)
final class RpcServiceGenerator
extends AbstractImplicitGenerator {
    private static final JavaTypeName CHECK_RETURN_VALUE_ANNOTATION = JavaTypeName.create((String)"edu.umd.cs.findbugs.annotations", (String)"CheckReturnValue");
    private final List<RpcGenerator> rpcs;

    RpcServiceGenerator(ModuleGenerator parent, List<RpcGenerator> rpcs) {
        super(parent);
        this.rpcs = Objects.requireNonNull(rpcs);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.RPC_SERVICE;
    }

    @Override
    String classSuffix() {
        return "Service";
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.RPC_SERVICE);
        for (RpcGenerator rpcGen : this.rpcs) {
            RpcEffectiveStatement rpc = (RpcEffectiveStatement)rpcGen.statement();
            QName qname = (QName)rpc.argument();
            MethodSignatureBuilder method = builder.addMethod(BindingMapping.getRpcMethodName((QName)qname));
            method.addParameter((Type)RpcServiceGenerator.getChild(rpcGen, InputEffectiveStatement.class).getGeneratedType(builderFactory), "input");
            method.setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)RpcServiceGenerator.getChild(rpcGen, OutputEffectiveStatement.class).getGeneratedType(builderFactory))));
            method.addAnnotation(CHECK_RETURN_VALUE_ANNOTATION);
            String rpcName = qname.getLocalName();
            method.setComment(new TypeMemberComment("Invoke {@code " + rpcName + "} RPC.", (String)rpc.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class).orElse(null), "@param input of {@code " + rpcName + "}\n@return output of {@code " + rpcName + "}"));
        }
        return builder.build();
    }
}

