/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassNamingStrategy;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;

@NonNullByDefault
final class YangDataNamingStrategy
extends ClassNamingStrategy {
    private final String javaIdentifier;

    YangDataNamingStrategy(String templateName) {
        this.javaIdentifier = BindingMapping.mapYangDataName((String)templateName);
    }

    @Override
    String simpleClassName() {
        return this.javaIdentifier;
    }

    @Override
    @Nullable ClassNamingStrategy fallback() {
        return null;
    }

    @Override
    String rootName() {
        return this.javaIdentifier;
    }

    @Override
    String childPackage() {
        return this.javaIdentifier + "$";
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("javaIdentifier", (Object)this.javaIdentifier);
    }
}

