/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.rt;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.InputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.OutputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.YangDataRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class DefaultBindingRuntimeTypes
implements BindingRuntimeTypes {
    private final @NonNull EffectiveModelContext context;
    private final ImmutableSetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases;
    private final ImmutableMap<QNameModule, ModuleRuntimeType> modulesByNamespace;
    private final ImmutableSortedMap<String, ModuleRuntimeType> modulesByPackage;
    private final ImmutableMap<QName, IdentityRuntimeType> identities;
    private final ImmutableMap<QName, OutputRuntimeType> rpcOutputs;
    private final ImmutableMap<QName, InputRuntimeType> rpcInputs;
    private final ImmutableMap<JavaTypeName, RuntimeType> types;

    public DefaultBindingRuntimeTypes(EffectiveModelContext context, Map<QNameModule, ModuleRuntimeType> modules, Map<JavaTypeName, RuntimeType> types, Map<QName, IdentityRuntimeType> identities, Map<QName, InputRuntimeType> rpcInputs, Map<QName, OutputRuntimeType> rpcOutputs, SetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases) {
        this.context = Objects.requireNonNull(context);
        this.identities = ImmutableMap.copyOf(identities);
        this.types = ImmutableMap.copyOf(types);
        this.rpcInputs = ImmutableMap.copyOf(rpcInputs);
        this.rpcOutputs = ImmutableMap.copyOf(rpcOutputs);
        this.choiceToCases = ImmutableSetMultimap.copyOf(choiceToCases);
        this.modulesByNamespace = ImmutableMap.copyOf(modules);
        this.modulesByPackage = ImmutableSortedMap.copyOf((Map)Maps.uniqueIndex(modules.values(), module -> module.getIdentifier().packageName()));
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.context;
    }

    public Optional<IdentityRuntimeType> findIdentity(QName qname) {
        return Optional.ofNullable((IdentityRuntimeType)this.identities.get((Object)Objects.requireNonNull(qname)));
    }

    public Optional<RuntimeType> findSchema(JavaTypeName typeName) {
        return Optional.ofNullable((RuntimeType)this.types.get((Object)Objects.requireNonNull(typeName)));
    }

    public GeneratedRuntimeType bindingChild(JavaTypeName typeName) {
        Map.Entry entry = this.modulesByPackage.floorEntry((Object)typeName.packageName());
        return entry == null ? null : ((ModuleRuntimeType)entry.getValue()).bindingChild(typeName);
    }

    public RuntimeType schemaTreeChild(QName qname) {
        ModuleRuntimeType module = (ModuleRuntimeType)this.modulesByNamespace.get((Object)qname.getModule());
        return module == null ? null : module.schemaTreeChild(qname);
    }

    public Optional<InputRuntimeType> findRpcInput(QName rpcName) {
        return Optional.ofNullable((InputRuntimeType)this.rpcInputs.get((Object)Objects.requireNonNull(rpcName)));
    }

    public Optional<OutputRuntimeType> findRpcOutput(QName rpcName) {
        return Optional.ofNullable((OutputRuntimeType)this.rpcOutputs.get((Object)Objects.requireNonNull(rpcName)));
    }

    public Optional<YangDataRuntimeType> findYangData(YangDataName templateName) {
        ModuleRuntimeType module = (ModuleRuntimeType)this.modulesByNamespace.get((Object)templateName.module());
        return module == null ? Optional.empty() : Optional.ofNullable(module.yangDataChild(templateName));
    }

    public Set<CaseRuntimeType> allCaseChildren(ChoiceRuntimeType choiceType) {
        return this.choiceToCases.get((Object)choiceType.getIdentifier());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("modules", (Object)this.modulesByNamespace.keySet()).add("identities", this.identities.size()).add("types", this.types.size()).toString();
    }
}

