/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.FeatureSet;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.DerivedNamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceNotAvailableException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.meta.SomeModifiersUnresolvedException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundles;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveSchemaContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorDeclaredModel;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SimpleNamespaceContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.VirtualNamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BuildGlobalContext
extends NamespaceStorageSupport
implements NamespaceBehaviour.Registry {
    private static final Logger LOG = LoggerFactory.getLogger(BuildGlobalContext.class);
    private static final ModelProcessingPhase[] PHASE_EXECUTION_ORDER = new ModelProcessingPhase[]{ModelProcessingPhase.SOURCE_PRE_LINKAGE, ModelProcessingPhase.SOURCE_LINKAGE, ModelProcessingPhase.STATEMENT_DEFINITION, ModelProcessingPhase.FULL_DECLARATION, ModelProcessingPhase.EFFECTIVE_MODEL};
    private final Table<YangVersion, QName, StatementDefinitionContext<?, ?, ?>> definitions = HashBasedTable.create();
    private final Map<QName, StatementDefinitionContext<?, ?, ?>> modelDefinedStmtDefs = new HashMap();
    private final Map<ParserNamespace<?, ?>, NamespaceBehaviourWithListeners<?, ?>> supportedNamespaces = new HashMap();
    private final List<MutableStatement> mutableStatementsToSeal = new ArrayList<MutableStatement>();
    private final ImmutableMap<ModelProcessingPhase, StatementSupportBundle> supports;
    private final Set<SourceSpecificContext> sources = new HashSet<SourceSpecificContext>();
    private final ImmutableSet<YangVersion> supportedVersions;
    private Set<SourceSpecificContext> libSources = new HashSet<SourceSpecificContext>();
    private ModelProcessingPhase currentPhase = ModelProcessingPhase.INIT;
    private ModelProcessingPhase finishedPhase = ModelProcessingPhase.INIT;

    BuildGlobalContext(ImmutableMap<ModelProcessingPhase, StatementSupportBundle> supports, ImmutableMap<ValidationBundles.ValidationBundleType, Collection<?>> supportedValidation) {
        this.supports = Objects.requireNonNull(supports, "BuildGlobalContext#supports cannot be null");
        this.addToNamespace(ValidationBundles.NAMESPACE, supportedValidation);
        this.supportedVersions = ImmutableSet.copyOf((Collection)((StatementSupportBundle)Verify.verifyNotNull((Object)((StatementSupportBundle)supports.get((Object)ModelProcessingPhase.INIT)))).getSupportedVersions());
    }

    StatementSupportBundle getSupportsForPhase(ModelProcessingPhase phase) {
        return (StatementSupportBundle)this.supports.get((Object)phase);
    }

    void addSource(@NonNull StatementStreamSource source) {
        this.sources.add(new SourceSpecificContext(this, source));
    }

    void addLibSource(@NonNull StatementStreamSource libSource) {
        Preconditions.checkState((this.currentPhase == ModelProcessingPhase.INIT ? 1 : 0) != 0, (Object)"Add library source is allowed in ModelProcessingPhase.INIT only");
        this.libSources.add(new SourceSpecificContext(this, libSource));
    }

    void setSupportedFeatures(Set<QName> supportedFeatures) {
        if (supportedFeatures instanceof FeatureSet) {
            this.addToNamespace(ParserNamespaces.SUPPORTED_FEATURES, Empty.value(), supportedFeatures);
        } else {
            this.addToNamespace(ParserNamespaces.SUPPORTED_FEATURES, Empty.value(), ImmutableSet.copyOf(supportedFeatures));
        }
    }

    void setModulesDeviatedByModules(SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
        this.addToNamespace(ParserNamespaces.MODULES_DEVIATED_BY, Empty.value(), ImmutableSetMultimap.copyOf(modulesDeviatedByModules));
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.GLOBAL;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return null;
    }

    @Override
    public NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this;
    }

    public <K, V> NamespaceBehaviourWithListeners<K, V> getNamespaceBehaviour(ParserNamespace<K, V> type) {
        NamespaceBehaviourWithListeners<Object, Object> potential = this.supportedNamespaces.get(type);
        if (potential == null) {
            NamespaceBehaviour potentialRaw = ((StatementSupportBundle)Verify.verifyNotNull((Object)((StatementSupportBundle)this.supports.get((Object)this.currentPhase)))).getNamespaceBehaviour(type);
            if (potentialRaw != null) {
                potential = this.createNamespaceContext(potentialRaw);
                this.supportedNamespaces.put(type, potential);
            } else {
                throw new NamespaceNotAvailableException("Namespace " + type + " is not available in phase " + this.currentPhase);
            }
        }
        Verify.verify((boolean)type.equals(potential.getIdentifier()));
        return potential;
    }

    private <K, V> NamespaceBehaviourWithListeners<K, V> createNamespaceContext(NamespaceBehaviour<K, V> potentialRaw) {
        if (potentialRaw instanceof DerivedNamespaceBehaviour) {
            DerivedNamespaceBehaviour derived = (DerivedNamespaceBehaviour)potentialRaw;
            VirtualNamespaceContext derivedContext = new VirtualNamespaceContext(derived);
            this.getNamespaceBehaviour(derived.getDerivedFrom()).addDerivedNamespace(derivedContext);
            return derivedContext;
        }
        return new SimpleNamespaceContext<K, V>(potentialRaw);
    }

    StatementDefinitionContext<?, ?, ?> getStatementDefinition(YangVersion version, QName name) {
        StatementSupport potentialRaw;
        StatementDefinitionContext potential = (StatementDefinitionContext)this.definitions.get((Object)version, (Object)name);
        if (potential == null && (potentialRaw = ((StatementSupportBundle)Verify.verifyNotNull((Object)((StatementSupportBundle)this.supports.get((Object)this.currentPhase)))).getStatementDefinition(version, name)) != null) {
            potential = new StatementDefinitionContext(potentialRaw);
            this.definitions.put((Object)version, (Object)name, potential);
        }
        return potential;
    }

    StatementDefinitionContext<?, ?, ?> getModelDefinedStatementDefinition(QName name) {
        return this.modelDefinedStmtDefs.get(name);
    }

    void putModelDefinedStatementDefinition(QName name, StatementDefinitionContext<?, ?, ?> def) {
        this.modelDefinedStmtDefs.put(name, def);
    }

    private void executePhases() throws ReactorException {
        for (ModelProcessingPhase phase : PHASE_EXECUTION_ORDER) {
            this.startPhase(phase);
            this.loadPhaseStatements();
            this.completePhaseActions();
            this.endPhase(phase);
        }
    }

    ReactorDeclaredModel build() throws ReactorException {
        this.executePhases();
        return this.transform();
    }

    EffectiveSchemaContext buildEffective() throws ReactorException {
        this.executePhases();
        return this.transformEffective();
    }

    private ReactorDeclaredModel transform() {
        Preconditions.checkState((this.finishedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        ArrayList rootStatements = new ArrayList(this.sources.size());
        for (SourceSpecificContext source : this.sources) {
            rootStatements.add((DeclaredStatement<?>)source.getRoot().declared());
        }
        return new ReactorDeclaredModel(rootStatements);
    }

    private SomeModifiersUnresolvedException propagateException(SourceSpecificContext source, RuntimeException cause) throws SomeModifiersUnresolvedException {
        SourceIdentifier sourceId = BuildGlobalContext.createSourceIdentifier(source.getRoot());
        if (!(cause instanceof SourceException)) {
            LOG.warn("Unexpected error processing source {}. Please file an issue with this model attached.", (Object)sourceId, (Object)cause);
        }
        throw new SomeModifiersUnresolvedException(this.currentPhase, sourceId, (Throwable)cause);
    }

    private static SourceIdentifier createSourceIdentifier(StmtContext<?, ?, ?> root) {
        QNameModule qNameModule = (QNameModule)root.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, root);
        Object arg = root.getArgument();
        Verify.verify((boolean)(arg instanceof UnresolvedQName.Unqualified), (String)"Unexpected argument %s", (Object)arg);
        if (qNameModule != null) {
            return new SourceIdentifier((UnresolvedQName.Unqualified)arg, (Revision)qNameModule.getRevision().orElse(null));
        }
        return new SourceIdentifier((UnresolvedQName.Unqualified)arg, (Revision)StmtContextUtils.getLatestRevision((Iterable)root.declaredSubstatements()).orElse(null));
    }

    private EffectiveSchemaContext transformEffective() throws ReactorException {
        Preconditions.checkState((this.finishedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        ArrayList rootStatements = new ArrayList(this.sources.size());
        ArrayList rootEffectiveStatements = new ArrayList(this.sources.size());
        for (SourceSpecificContext source : this.sources) {
            RootStatementContext<?, ?, ?> root = source.getRoot();
            try {
                rootStatements.add((DeclaredStatement<?>)root.declared());
                rootEffectiveStatements.add((EffectiveStatement<?, ?>)root.buildEffective());
            }
            catch (RuntimeException ex) {
                throw this.propagateException(source, ex);
            }
        }
        this.sealMutableStatements();
        return EffectiveSchemaContext.create(rootStatements, rootEffectiveStatements);
    }

    private void startPhase(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)Objects.equals(this.finishedPhase, phase.getPreviousPhase()));
        BuildGlobalContext.startPhaseFor(phase, this.sources);
        BuildGlobalContext.startPhaseFor(phase, this.libSources);
        this.currentPhase = phase;
        LOG.debug("Global phase {} started", (Object)phase);
    }

    private static void startPhaseFor(ModelProcessingPhase phase, Set<SourceSpecificContext> sources) {
        for (SourceSpecificContext source : sources) {
            source.startPhase(phase);
        }
    }

    private void loadPhaseStatements() throws ReactorException {
        Preconditions.checkState((this.currentPhase != null ? 1 : 0) != 0);
        this.loadPhaseStatementsFor(this.sources);
        this.loadPhaseStatementsFor(this.libSources);
    }

    private void loadPhaseStatementsFor(Set<SourceSpecificContext> srcs) throws ReactorException {
        for (SourceSpecificContext source : srcs) {
            try {
                source.loadStatements();
            }
            catch (RuntimeException ex) {
                throw this.propagateException(source, ex);
            }
        }
    }

    private SomeModifiersUnresolvedException addSourceExceptions(List<SourceSpecificContext> sourcesToProgress) {
        boolean addedCause = false;
        SomeModifiersUnresolvedException buildFailure = null;
        for (SourceSpecificContext failedSource : sourcesToProgress) {
            Object cause;
            Optional<SourceException> optSourceEx = failedSource.failModifiers(this.currentPhase);
            if (optSourceEx.isEmpty()) continue;
            SourceException sourceEx = optSourceEx.orElseThrow();
            Object object = cause = sourceEx.getCause() != null ? sourceEx.getCause() : sourceEx;
            if (LOG.isDebugEnabled()) {
                LOG.error("Failed to parse YANG from source {}", (Object)failedSource, (Object)sourceEx);
            } else {
                LOG.error("Failed to parse YANG from source {}: {}", (Object)failedSource, (Object)((Throwable)cause).getMessage());
            }
            Throwable[] suppressed = sourceEx.getSuppressed();
            if (suppressed.length > 0) {
                LOG.error("{} additional errors reported:", (Object)suppressed.length);
                int count = 1;
                for (Throwable t : suppressed) {
                    LOG.error("Error {}: {}", (Object)count, (Object)t.getMessage());
                    ++count;
                }
            }
            if (!addedCause) {
                addedCause = true;
                SourceIdentifier sourceId = BuildGlobalContext.createSourceIdentifier(failedSource.getRoot());
                buildFailure = new SomeModifiersUnresolvedException(this.currentPhase, sourceId, (Throwable)sourceEx);
                continue;
            }
            buildFailure.addSuppressed((Throwable)sourceEx);
        }
        return buildFailure;
    }

    private void completePhaseActions() throws ReactorException {
        SomeModifiersUnresolvedException buildFailure;
        Preconditions.checkState((this.currentPhase != null ? 1 : 0) != 0);
        ArrayList<SourceSpecificContext> sourcesToProgress = new ArrayList<SourceSpecificContext>(this.sources);
        if (!this.libSources.isEmpty()) {
            Preconditions.checkState((this.currentPhase == ModelProcessingPhase.SOURCE_PRE_LINKAGE ? 1 : 0) != 0, (String)"Yang library sources should be empty after ModelProcessingPhase.SOURCE_PRE_LINKAGE, but current phase was %s", (Object)this.currentPhase);
            sourcesToProgress.addAll(this.libSources);
        }
        boolean progressing = true;
        while (progressing) {
            progressing = false;
            Iterator currentSource = sourcesToProgress.iterator();
            while (currentSource.hasNext()) {
                SourceSpecificContext nextSourceCtx = (SourceSpecificContext)currentSource.next();
                try {
                    SourceSpecificContext.PhaseCompletionProgress sourceProgress = nextSourceCtx.tryToCompletePhase(this.currentPhase.executionOrder());
                    switch (sourceProgress) {
                        case FINISHED: {
                            currentSource.remove();
                            progressing = true;
                            break;
                        }
                        case PROGRESS: {
                            progressing = true;
                            break;
                        }
                        case NO_PROGRESS: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported phase progress " + sourceProgress);
                        }
                    }
                }
                catch (RuntimeException ex) {
                    throw this.propagateException(nextSourceCtx, ex);
                }
            }
        }
        if (!this.libSources.isEmpty()) {
            Set<SourceSpecificContext> requiredLibs = this.getRequiredSourcesFromLib();
            this.sources.addAll(requiredLibs);
            this.libSources = ImmutableSet.of();
            sourcesToProgress.retainAll(this.sources);
        }
        if (!sourcesToProgress.isEmpty() && (buildFailure = this.addSourceExceptions(sourcesToProgress)) != null) {
            throw buildFailure;
        }
    }

    private Set<SourceSpecificContext> getRequiredSourcesFromLib() {
        Preconditions.checkState((this.currentPhase == ModelProcessingPhase.SOURCE_PRE_LINKAGE ? 1 : 0) != 0, (String)"Required library sources can be collected only in ModelProcessingPhase.SOURCE_PRE_LINKAGE phase, but current phase was %s", (Object)this.currentPhase);
        TreeBasedTable libSourcesTable = TreeBasedTable.create(UnresolvedQName.Unqualified::compareTo, Revision::compare);
        for (SourceSpecificContext libSource : this.libSources) {
            SourceIdentifier libSourceIdentifier = Objects.requireNonNull(libSource.getRootIdentifier());
            libSourcesTable.put((Object)libSourceIdentifier.name(), Optional.ofNullable(libSourceIdentifier.revision()), (Object)libSource);
        }
        HashSet<SourceSpecificContext> requiredLibs = new HashSet<SourceSpecificContext>();
        for (SourceSpecificContext source : this.sources) {
            this.collectRequiredSourcesFromLib((TreeBasedTable<UnresolvedQName.Unqualified, Optional<Revision>, SourceSpecificContext>)libSourcesTable, requiredLibs, source);
            BuildGlobalContext.removeConflictingLibSources(source, requiredLibs);
        }
        return requiredLibs;
    }

    private void collectRequiredSourcesFromLib(TreeBasedTable<UnresolvedQName.Unqualified, Optional<Revision>, SourceSpecificContext> libSourcesTable, Set<SourceSpecificContext> requiredLibs, SourceSpecificContext source) {
        for (SourceIdentifier requiredSource : source.getRequiredSources()) {
            SourceSpecificContext libSource = BuildGlobalContext.getRequiredLibSource(requiredSource, libSourcesTable);
            if (libSource == null || !requiredLibs.add(libSource)) continue;
            this.collectRequiredSourcesFromLib(libSourcesTable, requiredLibs, libSource);
        }
    }

    private static SourceSpecificContext getRequiredLibSource(SourceIdentifier requiredSource, TreeBasedTable<UnresolvedQName.Unqualified, Optional<Revision>, SourceSpecificContext> libSourcesTable) {
        Revision revision = requiredSource.revision();
        return revision != null ? (SourceSpecificContext)libSourcesTable.get((Object)requiredSource.name(), Optional.of(revision)) : BuildGlobalContext.getLatestRevision(libSourcesTable.row((Object)requiredSource.name()));
    }

    private static SourceSpecificContext getLatestRevision(SortedMap<Optional<Revision>, SourceSpecificContext> sourceMap) {
        return sourceMap != null && !sourceMap.isEmpty() ? (SourceSpecificContext)sourceMap.get(sourceMap.lastKey()) : null;
    }

    private static void removeConflictingLibSources(SourceSpecificContext source, Set<SourceSpecificContext> requiredLibs) {
        Iterator<SourceSpecificContext> requiredLibsIter = requiredLibs.iterator();
        while (requiredLibsIter.hasNext()) {
            SourceSpecificContext currentReqSource = requiredLibsIter.next();
            if (!source.getRootIdentifier().equals((Object)currentReqSource.getRootIdentifier())) continue;
            requiredLibsIter.remove();
        }
    }

    private void endPhase(ModelProcessingPhase phase) {
        Preconditions.checkState((this.currentPhase == phase ? 1 : 0) != 0);
        this.finishedPhase = this.currentPhase;
        LOG.debug("Global phase {} finished", (Object)phase);
    }

    Set<SourceSpecificContext> getSources() {
        return this.sources;
    }

    public Set<YangVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    void addMutableStmtToSeal(MutableStatement mutableStatement) {
        this.mutableStatementsToSeal.add(mutableStatement);
    }

    void sealMutableStatements() {
        for (MutableStatement mutableStatement : this.mutableStatementsToSeal) {
            mutableStatement.seal();
        }
        this.mutableStatementsToSeal.clear();
    }
}

