/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.command;

import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.command.completers.JobNameCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="scheduler", name="reschedule", description="Update scheduling of an existing job")
@Service
public class Reschedule
implements Action {
    @Argument(name="name", required=true, description="The job name")
    @Completion(value=JobNameCompleter.class)
    String name;
    @Option(name="--concurrent", description="Should jobs run concurrently or not (defaults to false)")
    boolean concurrent;
    @Option(name="--cron", description="The cron expression")
    String cron;
    @Option(name="--at", description="Absolute date in ISO format (ex: 2014-05-13T13:56:45)")
    String at;
    @Option(name="--times", description="Number of times this job should be executed")
    int times = -1;
    @Option(name="--period", description="Time during executions (in seconds)")
    long period;
    @Reference
    Scheduler scheduler;

    public Object execute() throws Exception {
        ScheduleOptions options;
        if (this.cron != null && (this.at != null || this.times != -1 || this.period != 0L)) {
            throw new IllegalArgumentException("Both cron expression and explicit execution time can not be specified");
        }
        if (this.cron != null) {
            options = this.scheduler.EXPR(this.cron);
        } else {
            Date date = this.at != null ? DatatypeConverter.parseDateTime((String)this.at).getTime() : new Date();
            options = this.period > 0L ? this.scheduler.AT(date, this.times, this.period) : this.scheduler.AT(date);
        }
        options.name(this.name);
        if (this.concurrent) {
            options.canRunConcurrently(this.concurrent);
        }
        this.scheduler.reschedule(this.name, options);
        return null;
    }
}

