/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.storage.journal.MappableJournalSegmentReader;
import io.atomix.storage.journal.MappableJournalSegmentWriter;
import io.atomix.storage.journal.StorageException;
import io.atomix.storage.journal.StorageLevel;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.SparseJournalIndex;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class JournalSegment<E>
implements AutoCloseable {
    private final JournalSegmentFile file;
    private final JournalSegmentDescriptor descriptor;
    private final StorageLevel storageLevel;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final JournalSerdes namespace;
    private final MappableJournalSegmentWriter<E> writer;
    private final Set<MappableJournalSegmentReader<E>> readers = ConcurrentHashMap.newKeySet();
    private final AtomicInteger references = new AtomicInteger();
    private boolean open = true;

    public JournalSegment(JournalSegmentFile file, JournalSegmentDescriptor descriptor, StorageLevel storageLevel, int maxEntrySize, double indexDensity, JournalSerdes namespace) {
        this.file = file;
        this.descriptor = descriptor;
        this.storageLevel = storageLevel;
        this.maxEntrySize = maxEntrySize;
        this.index = new SparseJournalIndex(indexDensity);
        this.namespace = namespace;
        this.writer = new MappableJournalSegmentWriter(this.openChannel(file.file()), this, maxEntrySize, this.index, namespace);
    }

    private FileChannel openChannel(File file) {
        try {
            return FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public long id() {
        return this.descriptor.id();
    }

    public long version() {
        return this.descriptor.version();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public int size() {
        return this.writer.size();
    }

    public JournalSegmentFile file() {
        return this.file;
    }

    public JournalSegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    void acquire() {
        if (this.references.getAndIncrement() == 0 && this.open) {
            this.map();
        }
    }

    void release() {
        if (this.references.decrementAndGet() == 0 && this.open) {
            this.unmap();
        }
    }

    private void map() {
        if (this.storageLevel == StorageLevel.MAPPED) {
            MappedByteBuffer buffer = this.writer.map();
            this.readers.forEach(reader -> reader.map(buffer));
        }
    }

    private void unmap() {
        if (this.storageLevel == StorageLevel.MAPPED) {
            this.writer.unmap();
            this.readers.forEach(reader -> reader.unmap());
        }
    }

    public MappableJournalSegmentWriter<E> writer() {
        this.checkOpen();
        return this.writer;
    }

    MappableJournalSegmentReader<E> createReader() {
        this.checkOpen();
        MappableJournalSegmentReader reader = new MappableJournalSegmentReader(this.openChannel(this.file.file()), this, this.maxEntrySize, this.index, this.namespace);
        MappedByteBuffer buffer = this.writer.buffer();
        if (buffer != null) {
            reader.map(buffer);
        }
        this.readers.add(reader);
        return reader;
    }

    void closeReader(MappableJournalSegmentReader<E> reader) {
        this.readers.remove(reader);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.unmap();
        this.writer.close();
        this.readers.forEach(reader -> reader.close());
        this.open = false;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.file.file().toPath());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("version", this.version()).add("index", this.index()).toString();
    }
}

