/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.FileChannelJournalSegmentWriter;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.MappedJournalSegmentWriter;
import io.atomix.storage.journal.StorageException;
import io.atomix.storage.journal.index.JournalIndex;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class MappableJournalSegmentWriter<E>
implements JournalWriter<E> {
    private final FileChannel channel;
    private final JournalSegment<E> segment;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final JournalSerdes namespace;
    private JournalWriter<E> writer;

    MappableJournalSegmentWriter(FileChannel channel, JournalSegment<E> segment, int maxEntrySize, JournalIndex index, JournalSerdes namespace) {
        this.channel = channel;
        this.segment = segment;
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.namespace = namespace;
        this.writer = new FileChannelJournalSegmentWriter<E>(channel, segment, maxEntrySize, index, namespace);
    }

    MappedByteBuffer map() {
        if (this.writer instanceof MappedJournalSegmentWriter) {
            return ((MappedJournalSegmentWriter)this.writer).buffer();
        }
        try {
            JournalWriter<E> writer = this.writer;
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.segment.descriptor().maxSegmentSize());
            this.writer = new MappedJournalSegmentWriter<E>(buffer, this.segment, this.maxEntrySize, this.index, this.namespace);
            writer.close();
            return buffer;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    void unmap() {
        if (this.writer instanceof MappedJournalSegmentWriter) {
            JournalWriter<E> writer = this.writer;
            this.writer = new FileChannelJournalSegmentWriter<E>(this.channel, this.segment, this.maxEntrySize, this.index, this.namespace);
            writer.close();
        }
    }

    MappedByteBuffer buffer() {
        JournalWriter<E> writer = this.writer;
        if (writer instanceof MappedJournalSegmentWriter) {
            return ((MappedJournalSegmentWriter)writer).buffer();
        }
        return null;
    }

    public long firstIndex() {
        return this.segment.index();
    }

    public int size() {
        try {
            return (int)this.channel.size();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public long getLastIndex() {
        return this.writer.getLastIndex();
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.writer.getLastEntry();
    }

    @Override
    public long getNextIndex() {
        return this.writer.getNextIndex();
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        return this.writer.append(entry);
    }

    @Override
    public void append(Indexed<E> entry) {
        this.writer.append(entry);
    }

    @Override
    public void commit(long index) {
        this.writer.commit(index);
    }

    @Override
    public void reset(long index) {
        this.writer.reset(index);
    }

    @Override
    public void truncate(long index) {
        this.writer.truncate(index);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

