/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;

abstract class KryoIOPool<T> {
    private final ConcurrentLinkedQueue<SoftReference<T>> queue = new ConcurrentLinkedQueue();

    KryoIOPool() {
    }

    private T borrow(int bufferSize) {
        SoftReference<T> reference;
        while ((reference = this.queue.poll()) != null) {
            T element = reference.get();
            if (element == null) continue;
            return element;
        }
        return this.create(bufferSize);
    }

    protected abstract T create(int var1);

    protected abstract boolean recycle(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R run(Function<T, R> function, int bufferSize) {
        T element = this.borrow(bufferSize);
        try {
            R r = function.apply(element);
            return r;
        }
        finally {
            if (this.recycle(element)) {
                this.queue.offer(new SoftReference<T>(element));
            }
        }
    }
}

