/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefUnionSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class UnionSpecificationSupport
extends AbstractTypeSupport<TypeStatement.UnionSpecification> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.TYPE).build();

    UnionSpecificationSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    protected TypeStatement.UnionSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw UnionSpecificationSupport.noType(ctx);
        }
        return new UnionSpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.UnionSpecification attachDeclarationReference(TypeStatement.UnionSpecification stmt, DeclarationReference reference) {
        return new RefUnionSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.UnionSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.UnionSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw UnionSpecificationSupport.noType(stmt);
        }
        UnionTypeBuilder builder = BaseTypes.unionTypeBuilder((QName)stmt.argumentAsTypeQName());
        for (EffectiveStatement subStmt : substatements) {
            if (!(subStmt instanceof TypeEffectiveStatement)) continue;
            builder.addType(((TypeEffectiveStatement)subStmt).getTypeDefinition());
        }
        return new TypeEffectiveStatementImpl((TypeStatement.UnionSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noType(@NonNull CommonStmtCtx stmt) {
        return new SourceException("At least one type statement has to be present", stmt);
    }
}

