/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class EntityType
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = 5757305139090513666L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    @ConstructorParameters(value={"value"})
    public EntityType(String _value) {
        if (_value != null) {
            EntityType.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public EntityType(EntityType source) {
        this._value = source._value;
    }

    public static EntityType getDefaultInstance(String defaultValue) {
        return new EntityType(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof EntityType)) return false;
        EntityType other = (EntityType)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(EntityType.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

