/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

class TerminalDataTreeCandidateNode
implements DataTreeCandidateNode {
    private ModificationType modificationType;
    private final YangInstanceIdentifier.PathArgument identifier;
    private final NormalizedNode before;
    private NormalizedNode after;
    private final HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> childNodes = new HashMap();
    private TerminalDataTreeCandidateNode parentNode;

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode data, TerminalDataTreeCandidateNode parentNode) {
        this(identifier, data);
        this.parentNode = Objects.requireNonNull(parentNode);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode data) {
        this(identifier, ModificationType.UNMODIFIED, data, data);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, ModificationType modificationType, NormalizedNode before, NormalizedNode after) {
        this.modificationType = modificationType;
        this.identifier = identifier;
        this.before = before;
        this.after = after;
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public Collection<DataTreeCandidateNode> getChildNodes() {
        return Collections.unmodifiableCollection(this.childNodes.values());
    }

    public Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        return Optional.ofNullable((DataTreeCandidateNode)this.childNodes.get(this.identifier));
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public Optional<NormalizedNode> getDataAfter() {
        return Optional.ofNullable(this.after);
    }

    @NonNull Optional<NormalizedNode> getDataAfter(YangInstanceIdentifier.PathArgument id) {
        return this.getNode(id).flatMap(TerminalDataTreeCandidateNode::getDataAfter);
    }

    public Optional<NormalizedNode> getDataBefore() {
        return Optional.ofNullable(this.before);
    }

    @NonNull Optional<NormalizedNode> getDataBefore(YangInstanceIdentifier.PathArgument id) {
        return this.getNode(id).flatMap(TerminalDataTreeCandidateNode::getDataBefore);
    }

    void setAfter(NormalizedNode after) {
        this.after = after;
    }

    void addChildNode(TerminalDataTreeCandidateNode node) {
        this.childNodes.put(node.getIdentifier(), node);
    }

    void setModification(YangInstanceIdentifier.PathArgument id, ModificationType modification) {
        this.getNode(id).orElseThrow(() -> new IllegalArgumentException("No node with " + id + " id was found")).setModification(modification);
    }

    private void setModification(ModificationType modification) {
        this.modificationType = modification;
    }

    ModificationType getModification(YangInstanceIdentifier.PathArgument id) {
        return this.getNode(id).map(TerminalDataTreeCandidateNode::getModificationType).orElse(ModificationType.UNMODIFIED);
    }

    void deleteNode(YangInstanceIdentifier.PathArgument id) {
        if (id != null) {
            this.getNode((YangInstanceIdentifier.PathArgument)id).orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$deleteNode$1(org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier$PathArgument ), ()Ljava/lang/IllegalArgumentException;)((YangInstanceIdentifier.PathArgument)id)).parentNode.deleteChild(id);
        } else {
            this.modificationType = ModificationType.UNMODIFIED;
        }
    }

    private void deleteChild(YangInstanceIdentifier.PathArgument id) {
        this.childNodes.remove(id);
    }

    @NonNull Optional<TerminalDataTreeCandidateNode> getNode(YangInstanceIdentifier.PathArgument id) {
        if (id == null) {
            return Optional.of(this);
        }
        if (this.childNodes.isEmpty()) {
            return Optional.empty();
        }
        if (this.childNodes.containsKey(id)) {
            return Optional.ofNullable(this.childNodes.get(id));
        }
        return this.findNode(id);
    }

    void setData(YangInstanceIdentifier.PathArgument id, NormalizedNode node) {
        this.getNode(id).orElseThrow().setAfter(node);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(YangInstanceIdentifier.PathArgument id) {
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        this.childNodes.forEach((childIdentifier, childNode) -> nodes.add(childNode.childNodes));
        return this.findNode(nodes, id);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(Collection<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes, YangInstanceIdentifier.PathArgument id) {
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nextNodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        for (HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> map : nodes) {
            if (map.containsKey(id)) {
                return Optional.ofNullable(map.get(id));
            }
            map.forEach((childIdentifier, childNode) -> nextNodes.add(childNode.childNodes));
        }
        return this.findNode(nextNodes, id);
    }

    private static /* synthetic */ IllegalArgumentException lambda$deleteNode$1(YangInstanceIdentifier.PathArgument id) {
        return new IllegalArgumentException("No node with " + id + " id was found");
    }
}

