/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.CCR;
import org.opendaylight.controller.cluster.access.commands.ConnectClientFailure;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequestProxyV1;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;

public final class ConnectClientRequest
extends Request<ClientIdentifier, ConnectClientRequest> {
    private static final long serialVersionUID = 1L;
    private final ABIVersion minVersion;
    private final ABIVersion maxVersion;

    ConnectClientRequest(ClientIdentifier identifier, long txSequence, ActorRef replyTo, ABIVersion minVersion, ABIVersion maxVersion) {
        super(identifier, txSequence, replyTo);
        this.minVersion = Objects.requireNonNull(minVersion);
        this.maxVersion = Objects.requireNonNull(maxVersion);
    }

    public ConnectClientRequest(ClientIdentifier identifier, ActorRef replyTo, ABIVersion minVersion, ABIVersion maxVersion) {
        this(identifier, 0L, replyTo, minVersion, maxVersion);
    }

    private ConnectClientRequest(ConnectClientRequest request, ABIVersion version) {
        super(request, version);
        this.minVersion = request.minVersion;
        this.maxVersion = request.maxVersion;
    }

    public ABIVersion getMinVersion() {
        return this.minVersion;
    }

    public ABIVersion getMaxVersion() {
        return this.maxVersion;
    }

    public ConnectClientFailure toRequestFailure(RequestException cause) {
        return new ConnectClientFailure((ClientIdentifier)this.getTarget(), this.getSequence(), cause);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new CCR(this) : new ConnectClientRequestProxyV1(this);
    }

    @Override
    protected ConnectClientRequest cloneAsVersion(ABIVersion version) {
        return new ConnectClientRequest(this, version);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("minVersion", (Object)this.minVersion).add("maxVersion", (Object)this.maxVersion);
    }

    static interface SerialForm
    extends Request.SerialForm<ClientIdentifier, ConnectClientRequest> {
        @Override
        default public ConnectClientRequest readExternal(ObjectInput in, ClientIdentifier target, long sequence, ActorRef replyTo) throws IOException {
            return new ConnectClientRequest(target, sequence, replyTo, ABIVersion.inexactReadFrom(in), ABIVersion.inexactReadFrom(in));
        }

        @Override
        default public ClientIdentifier readTarget(DataInput in) throws IOException {
            return ClientIdentifier.readFrom(in);
        }

        @Override
        default public void writeExternal(ObjectOutput out, ConnectClientRequest msg) throws IOException {
            Request.SerialForm.super.writeExternal(out, msg);
            msg.getMinVersion().writeTo(out);
            msg.getMaxVersion().writeTo(out);
        }
    }
}

