/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

public abstract class RequestFailure<T extends WritableIdentifier, C extends RequestFailure<T, C>>
extends Response<T, C> {
    private static final long serialVersionUID = 1L;
    private final @NonNull RequestException cause;

    protected RequestFailure(@NonNull C failure, @NonNull ABIVersion version) {
        super(failure, version);
        this.cause = Objects.requireNonNull(((RequestFailure)failure).getCause());
    }

    protected RequestFailure(@NonNull T target, long sequence, @NonNull RequestException cause) {
        super(target, sequence);
        this.cause = Objects.requireNonNull(cause);
    }

    public final @NonNull RequestException getCause() {
        return this.cause;
    }

    public final boolean isHardFailure() {
        return !this.cause.isRetriable();
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("cause", (Object)this.cause);
    }

    @Override
    protected abstract SerialForm<T, C> externalizableProxy(ABIVersion var1);

    protected static interface SerialForm<T extends WritableIdentifier, C extends RequestFailure<T, C>>
    extends Message.SerialForm<T, C> {
        @Override
        default public C readExternal(ObjectInput in, T target, long sequence) throws IOException, ClassNotFoundException {
            return this.createFailure(target, sequence, (RequestException)in.readObject());
        }

        @Override
        default public void writeExternal(ObjectOutput out, C msg) throws IOException {
            out.writeObject(((RequestFailure)msg).getCause());
        }

        public @NonNull C createFailure(@NonNull T var1, long var2, @NonNull RequestException var4);
    }
}

