/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.Headers;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiHttpServletRequestWrapper;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.undertow.internal.PaxWebServletInfo;
import org.ops4j.pax.web.service.undertow.internal.PaxWebSessionIdGenerator;
import org.ops4j.pax.web.service.undertow.internal.UndertowFactory;

public class PaxWebOuterHandlerWrapper
implements HandlerWrapper {
    private OsgiServletContext defaultServletContext;
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private String[] virtualHosts;
    private boolean[] virtualHostWildcards;
    private String[] connectorNames;

    public PaxWebOuterHandlerWrapper(OsgiSessionAttributeListener osgiSessionsBridge) {
        this.osgiSessionsBridge = osgiSessionsBridge;
    }

    public HttpHandler wrap(final HttpHandler handler) {
        return new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                HttpServletRequest incomingRequest = (HttpServletRequest)context.getServletRequest();
                String path = exchange.getRelativePath();
                if (path.regionMatches(true, 0, "/meta-inf", 0, "/meta-inf".length()) || path.regionMatches(true, 0, "/web-inf", 0, "/web-inf".length()) || path.regionMatches(true, 0, "/osgi-inf", 0, "/osgi-inf".length()) || path.regionMatches(true, 0, "/osgi-opt", 0, "/osgi-opt".length())) {
                    exchange.setStatusCode(404);
                    return;
                }
                String hostHeader = exchange.getRequestHeaders().getFirst(Headers.HOST);
                if (hostHeader == null) {
                    hostHeader = incomingRequest.getServerName();
                }
                String connectorName = (String)exchange.getConnection().getUndertowOptions().get(UndertowFactory.PAX_WEB_CONNECTOR_NAME);
                if (hostHeader.contains(":")) {
                    hostHeader = hostHeader.substring(0, hostHeader.lastIndexOf(":"));
                }
                if (!PaxWebOuterHandlerWrapper.this.matches(hostHeader, connectorName)) {
                    exchange.setStatusCode(404);
                    return;
                }
                ServletInfo servletInfo = context.getCurrentServlet().getManagedServlet().getServletInfo();
                OsgiContextModel osgiContextModel = null;
                if (servletInfo instanceof PaxWebServletInfo) {
                    OsgiHttpServletRequestWrapper req;
                    PaxWebServletInfo paxWebServletInfo = (PaxWebServletInfo)servletInfo;
                    if (!paxWebServletInfo.is404()) {
                        req = new OsgiHttpServletRequestWrapper(incomingRequest, (ServletContext)paxWebServletInfo.getServletContext(), PaxWebOuterHandlerWrapper.this.osgiSessionsBridge);
                        osgiContextModel = paxWebServletInfo.getServletContext().getOsgiContextModel();
                    } else {
                        req = new OsgiHttpServletRequestWrapper(incomingRequest, (ServletContext)PaxWebOuterHandlerWrapper.this.defaultServletContext, PaxWebOuterHandlerWrapper.this.osgiSessionsBridge);
                        osgiContextModel = PaxWebOuterHandlerWrapper.this.defaultServletContext.getOsgiContextModel();
                    }
                    context.setServletRequest((ServletRequest)req);
                }
                if (osgiContextModel != null) {
                    String sessionIdPrefix = osgiContextModel.getTemporaryLocation().replaceAll("/", "_");
                    PaxWebSessionIdGenerator.sessionIdPrefix.set(sessionIdPrefix);
                    String sessionCookie = context.getCurrentServletContext().getSessionCookieConfig().getName();
                    Cookie cookie = exchange.getRequestCookie(sessionCookie);
                    if (cookie != null) {
                        PaxWebSessionIdGenerator.cookieSessionId.set(cookie.getValue());
                    }
                }
                exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                    PaxWebSessionIdGenerator.sessionIdPrefix.set(null);
                    PaxWebSessionIdGenerator.cookieSessionId.set(null);
                    nextListener.proceed();
                });
                handler.handleRequest(exchange);
            }
        };
    }

    public OsgiServletContext getDefaultServletContext() {
        return this.defaultServletContext;
    }

    public void setDefaultServletContext(OsgiServletContext defaultServletContext) {
        this.defaultServletContext = defaultServletContext;
    }

    public void setVirtualHosts(String[] virtualHosts) {
        int size;
        int n = size = virtualHosts == null ? 0 : virtualHosts.length;
        if (size == 0) {
            this.virtualHosts = null;
            this.virtualHostWildcards = null;
            this.connectorNames = null;
        } else {
            this.virtualHosts = new String[size];
            this.virtualHostWildcards = new boolean[size];
            this.connectorNames = new String[size];
            for (int i = 0; i < size; ++i) {
                String host;
                this.virtualHosts[i] = null;
                this.virtualHostWildcards[i] = false;
                this.connectorNames[i] = null;
                String vh = virtualHosts[i];
                if (vh == null || "".equals(vh.trim())) continue;
                if (vh.startsWith("@")) {
                    this.connectorNames[i] = vh.substring(1);
                    continue;
                }
                String connector = null;
                int atpos = vh.indexOf("@");
                if (atpos >= 0) {
                    host = vh.substring(0, atpos).trim();
                    connector = vh.substring(atpos + 1).trim();
                } else {
                    host = vh.trim();
                }
                if (connector != null && !"".equals(connector)) {
                    this.connectorNames[i] = connector;
                }
                if ("".equals(host)) continue;
                this.virtualHosts[i] = host;
                if (!host.startsWith("*.")) continue;
                this.virtualHostWildcards[i] = true;
                this.virtualHosts[i] = host.substring(1);
            }
        }
    }

    public boolean matches(String vhost, String connectorName) {
        if (this.virtualHosts == null || this.virtualHosts.length == 0) {
            return true;
        }
        for (int i = 0; i < this.virtualHosts.length; ++i) {
            int index;
            String vh = this.virtualHosts[i];
            String connector = this.connectorNames[i];
            if (connector != null) {
                if (!connector.equalsIgnoreCase(connectorName)) continue;
                if (vh == null) {
                    return true;
                }
            }
            if (vh == null || !(this.virtualHostWildcards[i] ? (index = vhost.indexOf(".")) >= 0 && vhost.substring(index).equalsIgnoreCase(vh) : vhost.equalsIgnoreCase(vh))) continue;
            return true;
        }
        return false;
    }
}

