/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration;

import java.util.Map;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ResolvingContentHandler
implements ContentHandler {
    public static final Logger LOG = LoggerFactory.getLogger(ResolvingContentHandler.class);
    private final Map<String, String> config;
    private final ContentHandler target;

    public ResolvingContentHandler(Map<String, String> config, ContentHandler target) {
        this.config = config;
        this.target = target;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.target.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.target.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.target.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.target.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.target.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl resolvedAttributes = new AttributesImpl(atts);
        for (int i = 0; i < atts.getLength(); ++i) {
            resolvedAttributes.setAttribute(i, atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), Utils.resolve(this.config, (String)atts.getValue(i), null));
        }
        this.target.startElement(uri, localName, qName, resolvedAttributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.target.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.target.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.target.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.target.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.target.skippedEntity(name);
    }
}

