/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.clustering.it.provider.impl.FlappingSingletonService;
import org.opendaylight.controller.clustering.it.provider.impl.GetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.IdIntsListener;
import org.opendaylight.controller.clustering.it.provider.impl.PublishNotificationsTask;
import org.opendaylight.controller.clustering.it.provider.impl.RoutedGetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.SingletonGetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.WriteTransactionsHandler;
import org.opendaylight.controller.clustering.it.provider.impl.YnlListener;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.AddShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.AddShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.IsClientAbortedInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.IsClientAbortedOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.OdlMdsalLowlevelControlService;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterDefaultConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterDefaultConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemoveShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemoveShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDdtlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDdtlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterDefaultConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterDefaultConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDdtlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDdtlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsOutput;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;

@Singleton
@Component(service={})
public final class MdsalLowLevelTestProvider
implements OdlMdsalLowlevelControlService {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalLowLevelTestProvider.class);
    private final Registration registration;
    private final DistributedDataStoreInterface configDataStore;
    private final BindingNormalizedNodeSerializer bindingNormalizedNodeSerializer;
    private final DOMDataBroker domDataBroker;
    private final NotificationPublishService notificationPublishService;
    private final NotificationService notificationService;
    private final ClusterSingletonServiceProvider singletonService;
    private final DOMRpcProviderService domRpcService;
    private final DOMDataTreeChangeService domDataTreeChangeService;
    private final Map<InstanceIdentifier<?>, DOMRpcImplementationRegistration<RoutedGetConstantService>> routedRegistrations = new HashMap();
    private final Map<String, ListenerRegistration<YnlListener>> ynlRegistrations = new HashMap<String, ListenerRegistration<YnlListener>>();
    private DOMRpcImplementationRegistration<GetConstantService> globalGetConstantRegistration = null;
    private ClusterSingletonServiceRegistration getSingletonConstantRegistration;
    private FlappingSingletonService flappingSingletonService;
    private ListenerRegistration<DOMDataTreeChangeListener> dtclReg;
    private IdIntsListener idIntsListener;
    private final Map<String, PublishNotificationsTask> publishNotificationsTasks = new HashMap<String, PublishNotificationsTask>();

    @Inject
    @Activate
    public MdsalLowLevelTestProvider(@Reference RpcProviderService rpcRegistry, @Reference DOMRpcProviderService domRpcService, @Reference ClusterSingletonServiceProvider singletonService, @Reference DOMSchemaService schemaService, @Reference BindingNormalizedNodeSerializer bindingNormalizedNodeSerializer, @Reference NotificationPublishService notificationPublishService, @Reference NotificationService notificationService, @Reference DOMDataBroker domDataBroker, @Reference DistributedDataStoreInterface configDataStore) {
        this.domRpcService = domRpcService;
        this.singletonService = singletonService;
        this.bindingNormalizedNodeSerializer = bindingNormalizedNodeSerializer;
        this.notificationPublishService = notificationPublishService;
        this.notificationService = notificationService;
        this.domDataBroker = domDataBroker;
        this.configDataStore = configDataStore;
        this.domDataTreeChangeService = (DOMDataTreeChangeService)domDataBroker.getExtensions().getInstance(DOMDataTreeChangeService.class);
        this.registration = rpcRegistry.registerRpcImplementation(OdlMdsalLowlevelControlService.class, (RpcService)this);
    }

    @PreDestroy
    @Deactivate
    public void close() {
        this.registration.close();
    }

    public ListenableFuture<RpcResult<UnregisterSingletonConstantOutput>> unregisterSingletonConstant(UnregisterSingletonConstantInput input) {
        LOG.info("In unregisterSingletonConstant");
        if (this.getSingletonConstantRegistration == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior RPC was registered").buildFuture();
        }
        try {
            this.getSingletonConstantRegistration.close();
            this.getSingletonConstantRegistration = null;
            return RpcResultBuilder.success((Object)new UnregisterSingletonConstantOutputBuilder().build()).buildFuture();
        }
        catch (Exception e) {
            String msg = "Error closing the singleton constant service";
            LOG.error(msg, (Throwable)e);
            return RpcResultBuilder.failed().withError(ErrorType.APPLICATION, msg, (Throwable)e).buildFuture();
        }
    }

    public ListenableFuture<RpcResult<StartPublishNotificationsOutput>> startPublishNotifications(StartPublishNotificationsInput input) {
        LOG.info("In startPublishNotifications - input: {}", (Object)input);
        PublishNotificationsTask task = new PublishNotificationsTask(this.notificationPublishService, input.getId(), input.getSeconds().toJava(), input.getNotificationsPerSecond().toJava());
        this.publishNotificationsTasks.put(input.getId(), task);
        task.start();
        return RpcResultBuilder.success((Object)new StartPublishNotificationsOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<SubscribeDtclOutput>> subscribeDtcl(SubscribeDtclInput input) {
        LOG.info("In subscribeDtcl - input: {}", (Object)input);
        if (this.dtclReg != null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_EXISTS, "There is already a DataTreeChangeListener registered for id-ints").buildFuture();
        }
        this.idIntsListener = new IdIntsListener();
        this.dtclReg = this.domDataTreeChangeService.registerDataTreeChangeListener(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, WriteTransactionsHandler.ID_INT_YID), (DOMDataTreeChangeListener)this.idIntsListener);
        return RpcResultBuilder.success((Object)new SubscribeDtclOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<WriteTransactionsOutput>> writeTransactions(WriteTransactionsInput input) {
        return WriteTransactionsHandler.start(this.domDataBroker, input);
    }

    public ListenableFuture<RpcResult<IsClientAbortedOutput>> isClientAborted(IsClientAbortedInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<RemoveShardReplicaOutput>> removeShardReplica(RemoveShardReplicaInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<SubscribeYnlOutput>> subscribeYnl(SubscribeYnlInput input) {
        LOG.info("In subscribeYnl - input: {}", (Object)input);
        if (this.ynlRegistrations.containsKey(input.getId())) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_EXISTS, "There is already a listener registered for id: " + input.getId()).buildFuture();
        }
        this.ynlRegistrations.put(input.getId(), (ListenerRegistration<YnlListener>)this.notificationService.registerNotificationListener((NotificationListener)new YnlListener(input.getId())));
        return RpcResultBuilder.success((Object)new SubscribeYnlOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterBoundConstantOutput>> unregisterBoundConstant(UnregisterBoundConstantInput input) {
        LOG.info("In unregisterBoundConstant - {}", (Object)input);
        DOMRpcImplementationRegistration<RoutedGetConstantService> rpcRegistration = this.routedRegistrations.remove(input.getContext());
        if (rpcRegistration == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior RPC was registered for " + input.getContext()).buildFuture();
        }
        rpcRegistration.close();
        return RpcResultBuilder.success((Object)new UnregisterBoundConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterSingletonConstantOutput>> registerSingletonConstant(RegisterSingletonConstantInput input) {
        LOG.info("In registerSingletonConstant - input: {}", (Object)input);
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.INVALID_VALUE, "Constant value is null").buildFuture();
        }
        this.getSingletonConstantRegistration = SingletonGetConstantService.registerNew(this.singletonService, this.domRpcService, input.getConstant());
        return RpcResultBuilder.success((Object)new RegisterSingletonConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterDefaultConstantOutput>> registerDefaultConstant(RegisterDefaultConstantInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<UnregisterConstantOutput>> unregisterConstant(UnregisterConstantInput input) {
        LOG.info("In unregisterConstant");
        if (this.globalGetConstantRegistration == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior RPC was registered").buildFuture();
        }
        this.globalGetConstantRegistration.close();
        this.globalGetConstantRegistration = null;
        return RpcResultBuilder.success((Object)new UnregisterConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterFlappingSingletonOutput>> unregisterFlappingSingleton(UnregisterFlappingSingletonInput input) {
        LOG.info("In unregisterFlappingSingleton");
        if (this.flappingSingletonService == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior RPC was registered").buildFuture();
        }
        long flapCount = this.flappingSingletonService.setInactive();
        this.flappingSingletonService = null;
        return RpcResultBuilder.success((Object)new UnregisterFlappingSingletonOutputBuilder().setFlapCount(Long.valueOf(flapCount)).build()).buildFuture();
    }

    public ListenableFuture<RpcResult<AddShardReplicaOutput>> addShardReplica(AddShardReplicaInput input) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<RpcResult<SubscribeDdtlOutput>> subscribeDdtl(SubscribeDdtlInput input) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<RpcResult<RegisterBoundConstantOutput>> registerBoundConstant(RegisterBoundConstantInput input) {
        LOG.info("In registerBoundConstant - input: {}", (Object)input);
        if (input.getContext() == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.INVALID_VALUE, "Context value is null").buildFuture();
        }
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.INVALID_VALUE, "Constant value is null").buildFuture();
        }
        if (this.routedRegistrations.containsKey(input.getContext())) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_EXISTS, "There is already an rpc registered for context: " + input.getContext()).buildFuture();
        }
        DOMRpcImplementationRegistration<RoutedGetConstantService> rpcRegistration = RoutedGetConstantService.registerNew(this.bindingNormalizedNodeSerializer, this.domRpcService, input.getConstant(), input.getContext());
        this.routedRegistrations.put(input.getContext(), rpcRegistration);
        return RpcResultBuilder.success((Object)new RegisterBoundConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterFlappingSingletonOutput>> registerFlappingSingleton(RegisterFlappingSingletonInput input) {
        LOG.info("In registerFlappingSingleton");
        if (this.flappingSingletonService != null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_EXISTS, "There is already an rpc registered").buildFuture();
        }
        this.flappingSingletonService = new FlappingSingletonService(this.singletonService);
        return RpcResultBuilder.success((Object)new RegisterFlappingSingletonOutputBuilder().build()).buildFuture();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<RpcResult<UnsubscribeDtclOutput>> unsubscribeDtcl(UnsubscribeDtclInput input) {
        LOG.info("In unsubscribeDtcl");
        if (this.idIntsListener == null) return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior listener was registered").buildFuture();
        if (this.dtclReg == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior listener was registered").buildFuture();
        }
        long timeout = 120L;
        try {
            this.idIntsListener.tryFinishProcessing().get(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Unable to finish notification processing", (Throwable)e);
            return RpcResultBuilder.failed().withError(ErrorType.APPLICATION, "Unable to finish notification processing in " + timeout + " seconds", (Throwable)e).buildFuture();
        }
        this.dtclReg.close();
        this.dtclReg = null;
        if (!this.idIntsListener.hasTriggered()) {
            return RpcResultBuilder.failed().withError(ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, "id-ints listener has not received any notifications.").buildFuture();
        }
        try (DOMDataTreeReadTransaction rTx = this.domDataBroker.newReadOnlyTransaction();){
            Optional readResult = (Optional)rTx.read(LogicalDatastoreType.CONFIGURATION, WriteTransactionsHandler.ID_INT_YID).get();
            if (!readResult.isPresent()) {
                FluentFuture fluentFuture2 = RpcResultBuilder.failed().withError(ErrorType.APPLICATION, ErrorTag.DATA_MISSING, "No data read from id-ints list").buildFuture();
                return fluentFuture2;
            }
            boolean nodesEqual = this.idIntsListener.checkEqual((NormalizedNode)readResult.orElseThrow());
            if (!nodesEqual) {
                LOG.error("Final read of id-int does not match IdIntsListener's copy. {}", (Object)this.idIntsListener.diffWithLocalCopy((NormalizedNode)readResult.orElseThrow()));
            }
            FluentFuture fluentFuture = RpcResultBuilder.success((Object)new UnsubscribeDtclOutputBuilder().setCopyMatches(Boolean.valueOf(nodesEqual)).build()).buildFuture();
            return fluentFuture;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Final read of id-ints failed", (Throwable)e);
            return RpcResultBuilder.failed().withError(ErrorType.APPLICATION, "Final read of id-ints failed", (Throwable)e).buildFuture();
        }
    }

    public ListenableFuture<RpcResult<UnsubscribeYnlOutput>> unsubscribeYnl(UnsubscribeYnlInput input) {
        LOG.info("In unsubscribeYnl - input: {}", (Object)input);
        if (!this.ynlRegistrations.containsKey(input.getId())) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_MISSING, "No prior listener was registered for " + input.getId()).buildFuture();
        }
        ListenerRegistration<YnlListener> reg = this.ynlRegistrations.remove(input.getId());
        UnsubscribeYnlOutput output = ((YnlListener)reg.getInstance()).getOutput();
        reg.close();
        return RpcResultBuilder.success().withResult((Object)output).buildFuture();
    }

    public ListenableFuture<RpcResult<CheckPublishNotificationsOutput>> checkPublishNotifications(CheckPublishNotificationsInput input) {
        LOG.info("In checkPublishNotifications - input: {}", (Object)input);
        PublishNotificationsTask task = this.publishNotificationsTasks.get(input.getId());
        if (task == null) {
            return RpcResultBuilder.success((Object)new CheckPublishNotificationsOutputBuilder().setActive(Boolean.valueOf(false)).build()).buildFuture();
        }
        CheckPublishNotificationsOutputBuilder checkPublishNotificationsOutputBuilder = new CheckPublishNotificationsOutputBuilder().setActive(Boolean.valueOf(!task.isFinished()));
        if (task.getLastError() != null) {
            LOG.error("Last error for {}", (Object)task, (Object)task.getLastError());
            checkPublishNotificationsOutputBuilder.setLastError(task.getLastError().toString());
        }
        CheckPublishNotificationsOutput output = checkPublishNotificationsOutputBuilder.setPublishCount(Long.valueOf(task.getCurrentNotif())).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public ListenableFuture<RpcResult<ShutdownShardReplicaOutput>> shutdownShardReplica(ShutdownShardReplicaInput input) {
        LOG.info("In shutdownShardReplica - input: {}", (Object)input);
        String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.BAD_ELEMENT, shardName + "is not a valid shard name").buildFuture();
        }
        return this.shutdownShardGracefully(shardName, new ShutdownShardReplicaOutputBuilder().build());
    }

    private <T> SettableFuture<RpcResult<T>> shutdownShardGracefully(String shardName, final T success) {
        final SettableFuture rpcResult = SettableFuture.create();
        ActorUtils context = this.configDataStore.getActorUtils();
        long timeoutInMS = Math.max(context.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().$times(3L).toMillis(), 10000L);
        final FiniteDuration duration = FiniteDuration.apply((long)timeoutInMS, (TimeUnit)TimeUnit.MILLISECONDS);
        final Promise shutdownShardAsk = Futures.promise();
        context.findLocalShardAsync(shardName).onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable throwable, ActorRef actorRef) {
                if (throwable != null) {
                    shutdownShardAsk.failure(throwable);
                } else {
                    shutdownShardAsk.completeWith(Patterns.gracefulStop((ActorRef)actorRef, (FiniteDuration)duration, (Object)Shutdown.INSTANCE));
                }
            }
        }, context.getClientDispatcher());
        shutdownShardAsk.future().onComplete((Function1)new OnComplete<Boolean>(){

            public void onComplete(Throwable throwable, Boolean gracefulStopResult) {
                if (throwable != null) {
                    RpcResult failedResult = RpcResultBuilder.failed().withError(ErrorType.APPLICATION, "Failed to gracefully shutdown shard", throwable).build();
                    rpcResult.set((Object)failedResult);
                } else {
                    rpcResult.set((Object)RpcResultBuilder.success((Object)success).build());
                }
            }
        }, context.getClientDispatcher());
        return rpcResult;
    }

    public ListenableFuture<RpcResult<RegisterConstantOutput>> registerConstant(RegisterConstantInput input) {
        LOG.info("In registerConstant - input: {}", (Object)input);
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.INVALID_VALUE, "Constant value is null").buildFuture();
        }
        if (this.globalGetConstantRegistration != null) {
            return RpcResultBuilder.failed().withError(ErrorType.RPC, ErrorTag.DATA_EXISTS, "There is already an rpc registered").buildFuture();
        }
        this.globalGetConstantRegistration = GetConstantService.registerNew(this.domRpcService, input.getConstant());
        return RpcResultBuilder.success((Object)new RegisterConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterDefaultConstantOutput>> unregisterDefaultConstant(UnregisterDefaultConstantInput input) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<RpcResult<UnsubscribeDdtlOutput>> unsubscribeDdtl(UnsubscribeDdtlInput input) {
        throw new UnsupportedOperationException();
    }
}

