/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatements;
import org.opendaylight.yangtools.rfc8040.parser.OperationsValidateModuleAction;
import org.opendaylight.yangtools.rfc8040.parser.RefYangDataStatement;
import org.opendaylight.yangtools.rfc8040.parser.YangDataEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8040.parser.YangDataStatementImpl;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class YangDataStatementSupport
extends AbstractStringStatementSupport<YangDataStatement, YangDataEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangDataStatements.YANG_DATA).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.USES).build();

    public YangDataStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangDataStatements.YANG_DATA, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public void onStatementAdded(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        if (ctx.coerceParentContext().getParentContext() != null) {
            ctx.setUnsupported();
        }
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        StmtContext stmt;
        Collection stmts;
        if (!ctx.isSupportedToBuildEffective()) {
            return;
        }
        super.onFullDefinitionDeclared(ctx);
        if ("yang-api".equals(ctx.argument()) && (stmts = ctx.declaredSubstatements()).size() == 1 && (stmt = (StmtContext)stmts.iterator().next()).producesEffective(UsesEffectiveStatement.class) && "restconf".equals(stmt.rawArgument())) {
            OperationsValidateModuleAction.applyTo(ctx.coerceParentContext());
        }
    }

    public boolean isIgnoringIfFeatures() {
        return true;
    }

    public boolean isIgnoringConfig() {
        return true;
    }

    protected YangDataStatement createDeclared(BoundStmtCtx<String> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new YangDataStatementImpl(ctx.getRawArgument(), substatements);
    }

    protected YangDataStatement attachDeclarationReference(YangDataStatement stmt, DeclarationReference reference) {
        return new RefYangDataStatement(stmt, reference);
    }

    protected YangDataEffectiveStatement createEffective(EffectiveStmtCtx.Current<String, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        SchemaTreeEffectiveStatement substmt;
        List schemaSub = substatements.stream().filter(SchemaTreeEffectiveStatement.class::isInstance).map(SchemaTreeEffectiveStatement.class::cast).collect(Collectors.toUnmodifiableList());
        switch (schemaSub.size()) {
            case 0: {
                throw new MissingSubstatementException(stmt, "yang-data requires at least one substatement", new Object[0]);
            }
            case 1: {
                substmt = (SchemaTreeEffectiveStatement)schemaSub.get(0);
                SourceException.throwIf((!(substmt instanceof ChoiceEffectiveStatement) && !(substmt instanceof DataTreeEffectiveStatement) ? 1 : 0) != 0, stmt, (String)"%s is not a recognized container data node definition", (Object[])new Object[]{substmt});
                Verify.verify((boolean)(substmt instanceof DataSchemaNode), (String)"Unexpected single child %s", (Object)substmt);
                break;
            }
            default: {
                throw new InvalidSubstatementException(stmt, "yang-data requires exactly one container data node definition, found %s", new Object[]{schemaSub});
            }
        }
        DataSchemaNode child = (DataSchemaNode)substmt;
        return new YangDataEffectiveStatementImpl(stmt, substatements, child);
    }
}

