/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.ModuleInfoSnapshotResolver;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.YangFeature;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.model.repo.api.FeatureSet;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;

@Beta
public final class ModuleInfoSnapshotBuilder {
    private final SetMultimap<Class<? extends DataRoot>, YangFeature<?, ?>> moduleFeatures = HashMultimap.create();
    private final Set<YangModuleInfo> moduleInfos = new HashSet<YangModuleInfo>();
    private final YangParserFactory parserFactory;

    public ModuleInfoSnapshotBuilder(YangParserFactory parserFactory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> clazz) {
        YangModuleInfo moduleInfo;
        try {
            moduleInfo = BindingReflections.getModuleInfo(clazz);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to introspect " + clazz, e);
        }
        return this.add(moduleInfo);
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> ... classes) {
        for (Class<? extends BindingObject> clazz : classes) {
            this.add(clazz);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo info) {
        ModuleInfoSnapshotResolver.flatDependencies(this.moduleInfos, info);
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo ... infos) {
        for (YangModuleInfo info : infos) {
            this.add(info);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Iterable<? extends YangModuleInfo> infos) {
        for (YangModuleInfo yangModuleInfo : infos) {
            this.add(yangModuleInfo);
        }
        return this;
    }

    public <R extends DataRoot> @NonNull ModuleInfoSnapshotBuilder addModuleFeatures(Class<R> module, Set<? extends YangFeature<?, R>> supportedFeatures) {
        this.moduleFeatures.putAll(Objects.requireNonNull(module), (Iterable)ImmutableList.copyOf(supportedFeatures));
        return this;
    }

    public @NonNull ModuleInfoSnapshot build() throws YangParserException {
        YangParser parser = this.parserFactory.createParser();
        HashMap<SourceIdentifier, YangModuleInfo> mappedInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        for (YangModuleInfo info : this.moduleInfos) {
            YangTextSchemaSource source = ModuleInfoSnapshotResolver.toYangTextSource(info);
            mappedInfos.put(source.getIdentifier(), info);
            Class<?> infoClass = info.getClass();
            classLoaders.put(BindingMapping.getModelRootPackageName((String)infoClass.getPackage().getName()), infoClass.getClassLoader());
            try {
                parser.addSource((SchemaSourceRepresentation)source);
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new YangParserException("Failed to add source for " + info, e);
            }
        }
        if (!this.moduleFeatures.isEmpty()) {
            ImmutableMap.Builder featuresByModule = ImmutableMap.builderWithExpectedSize((int)this.moduleFeatures.size());
            for (Map.Entry entry : Multimaps.asMap(this.moduleFeatures).entrySet()) {
                featuresByModule.put((Object)BindingReflections.getQNameModule((Class)((Class)entry.getKey())), (Object)((ImmutableSet)((Set)entry.getValue()).stream().map(YangFeature::qname).map(AbstractQName::getLocalName).sorted().collect(ImmutableSet.toImmutableSet())));
            }
            parser.setSupportedFeatures((Set)new FeatureSet(featuresByModule.build()));
        }
        return new DefaultModuleInfoSnapshot(parser.buildEffectiveModel(), mappedInfos, classLoaders);
    }
}

