/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.eventexecutor;

import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public interface AutoCloseableEventExecutor
extends EventExecutor,
AutoCloseable {
    public static AutoCloseableEventExecutor globalEventExecutor() {
        return AutoCloseableEventExecutor.createCloseableProxy((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public static AutoCloseableEventExecutor immediateEventExecutor() {
        return AutoCloseableEventExecutor.createCloseableProxy((EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    private static AutoCloseableEventExecutor createCloseableProxy(final EventExecutor eventExecutor) {
        return (AutoCloseableEventExecutor)Reflection.newProxy(AutoCloseableEventExecutor.class, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close")) {
                    eventExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
                    return null;
                }
                return method.invoke((Object)eventExecutor, args);
            }
        });
    }
}

